#!/usr/bin/python

import sys
from jira.client import JIRA

alert_state = {}

with open(sys.argv[1]) as alert_state_file:
    for line in alert_state_file:
        name, var = line.partition("=")[::2]
        alert_state[name] = var.strip('\n\'')

# don't open ticket if alert is not currently failing
if(alert_state['ALERT_STATUS'] != 'fail'):
    exit(0)

jira = JIRA(options={'server': 'https://MYJIRASERVER'}, basic_auth=('MYUSERNAME', 'MYPASSWORD'))

summary = 'CFEngine Alert "%s" triggered' % (alert_state['ALERT_NAME'])

description = 'Severity %s alert is triggered on %s of %s nodes (at time of issue creation).' % (alert_state['ALERT_SEVERITY'],
                                                                                                 alert_state['ALERT_FAILED_HOST'],
                                                                                                 alert_state['ALERT_TOTAL_HOST'])

new_issue = jira.create_issue(project={'key': 'IN'}, summary=summary, description=description, issuetype={'name': 'Task'})
