<?php

class Engineering extends Cf_Controller
{
    function __construct()
    {
        parent::__construct();

        setCurrentApplication('engineering');
    }

    function index($hostkey = null)
    {
        $this->load->model('host_model');
        $this->username = $this->session->userdata('username');
        $hostFound = $this->host_model->getHostFound($this->username,$hostkey);
        if ($hostFound === false)
        {
            $this->custom_404();
            return;
        }

        $requiredjs = array(
            array('node_modules/jquery.flot/jquery.flot.js'),
            array('node_modules/jquery.flot/jquery.flot.stack.js'),
            array('node_modules/jquery.flot/jquery.flot.resize.js'),
            array('node_modules/jquery.flot/jquery.flot.fillbetween.js'),
            array('widgets/astrolabe.js'),
            array('widgets/astrolabeLocation.js'),
            array('widgets/combobox.js'),
            array('widgets/hostsCompliance.js'),
            array('widgets/hostsConnectivity.js'),
            array('widgets/hostInfo.js'),

            array('widgets/classfinder.js'),
            array('widgets/vitalsigns.js'),

            array('node_modules/datatables/media/js/jquery.dataTables.min.js'),
            array('libs/datatables/jquery.dataTables.bootstrap.js'),
            array('node_modules/jquery-appear-original/index.js'),

            array('node_modules/bootstrap-multiselect/dist/js/bootstrap-multiselect.min.js'),
            array('node_modules/clipboard/dist/clipboard.min.js'),
            array('host-page.js')
        );


        $this->carabiner->css(
                array(
                    array('contextfinder.css'),
                    array('datatables.css')
                )
        );


        $jsIE = array('node_modules/jquery.flot/excanvas.min.js');
        $this->carabiner->group('iefix', array('js' => $jsIE));
        $this->carabiner->js($requiredjs);

        $requiredAngularjs = array(
            array('node_modules/underscore/underscore-min.js'),
            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),

            // services
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('libs/class.js'),

            array('libs/baseclasses/BaseController.js'),
            array('libs/baseclasses/EventDispatcher.js'),
            array('libs/baseclasses/Notifications.js'),

            array('hostInfo/app.js'),
            array('hostInfo/controllers/hostInfoController.js'),
            array('hostInfo/services/cmdbService.js'),
            array('hostInfo/directives/cmdb.js'),
            array('hostInfo/data/cmdbSuggestions.js'),
            array('hubManagement/services/hubManagementService.js'),
            array('common_directives/objectsFilter.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);



        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('hosts_app_page_title'),
            'hostkey' => $hostkey
        );

        $this->template->load('template', 'engineering', $data);
    }
}