<?php

namespace FR\Interfaces;

/**
 * Interface ConfigFileEntityInterface
 * @package FR\Interfaces
 */
interface ConfigFileEntityInterface extends \JsonSerializable
{

    /**
     * @return string
     */
    public function getHostname();

    /**
     * @param $hostname string
     *
     * @return void
     */
    public function setHostname($hostname);

    /**
     * @param $role
     *
     * @return mixed
     */
    public function setRole($role);

    /**
     * @return string
     */
    public function getRole() : string ;

    /**
     * @return RemoteHubsCollectionInterface
     */
    public function getRemoteHubs() : RemoteHubsCollectionInterface;

    /**
     * @param RemoteHubsCollectionInterface $remoteHubs
     *
     * @return mixed
     */
    public function setRemoteHubs(RemoteHubsCollectionInterface $remoteHubs);

}
