<?php

$secretsIniPath = realpath(__DIR__ . '/../../../secrets.ini');
$secrets = [];
if (file_exists($secretsIniPath)) {
    $secrets = parse_ini_file(realpath(__DIR__ . '/../../../secrets.ini'));
}

/*
CONFIGURABLE VALUES FOR OAUTH
 */
define('OAUTH_DATABASE_NAME', 'cfsettings');
define('CFDB_DATABASE_NAME', 'cfdb');
define('OAUTH_DATABASE_PORT', 5432 );
define('OAUTH_DATABASE_HOST', '/tmp');
define('OAUTH_DATABASE_USER', 'cfpostgres');
define('OAUTH_DATABASE_PASS', null);
define('OAUTH_REFRESHTOKEN_TIME', 86400);
define('OAUTH_ACCESSTOKEN_TIME', 3600);
define('LDAP_API_SECRET_KEY', $secrets['ldap_api_secret'] ?? null);
define('LDAP_API_URL', 'https://127.0.0.1/ldap');
define('POLICY_PATH', '/opt/cfengine/analyzer/policy/masterfiles');
define('CF_RUN_AGENT_SOCKET', '/var/cfengine/state/cf-execd.sockets/runagent.socket');
define('BUILD_MODULES_URL', 'https://build.cfengine.com/js/modules.json');
define('USER_AGENT', 'CFEngine Enterprise API');


define('SSH_DIGEST_ALGORITHM', 'sha512');
define('SSH_PRIVATE_KEY_BITS', 4096);
define('SSH_PRIVATE_KEY_TYPE', OPENSSL_KEYTYPE_RSA);

define('MAX_NAME_LENGTH', 100);
define('MAX_VALUE_LENGTH', 16000);
define('MAX_CMDB_NAME_LENGTH', 255);
define('MAX_URL_LENGTH', 2048);
