<div class="settingsPage">

    <div class="left-column">
           <?php include(APPPATH.'views/appsetting/settingsSideBar.php');?>
    </div>
    <div class="right-column-tabs clearfix">
        <div class="pageTitleWithTabs">
            <h1><span>User management</span></h1>
        </div>

        <div id="tabs-layout" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
            <div class="tabWrapper">
                <ul class="admin_menu ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                    <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active ">
                        <a rel="users" href="<?php echo site_url('auth/index').'/users/'.$showUsers.'/rows/'.$number_of_rows.'/page/'.$current; ?>">Users</a>
                    </li>
                    <li class="ui-state-default ui-corner-top">
                        <a rel="roles" href="<?php echo site_url('auth/manage_role'); ?>">Roles</a>
                    </li>
                </ul>

                <div class="tab_section margin-bottom-large">
                    <div class="max-table">

                    <?php if ($rbac_setting !== true) { ?>
                        <div class="alert alert-warning"><strong>Note!</strong> RBAC is currently <b>globally off</b>, remember to turn it <b>on</b> in <a href="<?php echo site_url('settings/preferences')?>">Mission Portal settings</a> to enforce it.</div>
                    <?php } ?>
                         <div id="error_status"></div>
                         <div id="error_status1"></div>
                        <div id="admin_content" class="tables user_roles_management">
                            <?php include 'user_list.php'; ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>


    </div>
</div>

<div id="rolesModal" class="modal hide fade" role="dialog"  style="width:660px;margin-left:-330px;">
    <div class="modal-header">
        <a class="close closeForm btnCancel" href="#"><i class="bi bi-x"></i></a>
        <h2>Edit role</h2>
    </div>
    <div class="modal-body form-buttons">

    </div>
    <div class="modal-footer">
        <button class="btn btn-large btnCancel">Cancel</button>
        <button class="btn btn-large btn-primary" id="super_role_btn">
            Save
        </button>

    </div>
</div>

<div id="confirmation">
</div>

<script type="text/javascript">
'use strict'
    // common options for ajax requests
    $.ajaxSetup({
        beforeSend: function() {
            common.globalSpinner.show();
        },
        complete: function(){
            common.globalSpinner.hide();
        },
        success: function() {
            common.globalSpinner.hide();
        },
        error:function() {
            common.globalSpinner.hide();
        }

    });
    // global variables for ajax and drag&drop
    var options = {
        target:  '#admin_content',  // target element(s) to be updated with server response
        dataType: 'json',
        success: function (responseObj, statusText, xhr, $form) {
           $("#formInfoMessage").find('.alert').remove();

           if(responseObj.responseText!=undefined && responseObj.responseText.type!=undefined){
                $("#formInfoMessage").append('<div class="alert '+responseObj.responseText.type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+ responseObj.responseText.content+'</div>');
                $("#formInfoMessage").show();
                $('.modal-body').scrollTop(0);
             }

            if(responseObj.message!=undefined){
                var success = false;
                $.each(responseObj.message,function(type,content){
                    if ((type==="alert-error")||(type==="alert-warning")) {
                      $("#formInfoMessage").append('<div class="alert '+type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+content+'</div>')
                      $("#formInfoMessage").show();
                      $('.modal-body').scrollTop(0);
                    } else {
                        $('#error_status').append('<div class="alert '+type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+content+'</div>');
                        success = true;
                    }
                });

                if (success===true) {$('.bootbox').modal('hide')};
             }

             if(responseObj.status!=undefined && responseObj.status=='all_ok'){
               $('#admin_content').html(responseObj.responseText);
               $('#edit_form_wrapper').remove();
             }
            return;
        }
    };

    var $group = [];  //items with .selected_item class
    var li_pos = '';  // LI position to insert on drag
    var ul_pos = '';  // UL position to insert on drag

    var maxAllowedClasses = 5;
    var classesArray = ['crxi','crxx'];

    // options for edit forms
    var edit_form_options =  {
        target:  '#edit_form_wrapper',
        dataType: 'json',
        beforeSubmit: function(arr, $form, options)
        {
        },
        success: function (responseObj, statusText, xhr, $form) {
            $("#error_status").find('.alert').remove();
            if (responseObj.status == 'all_ok')
            {
                $("#formInfoMessage").find('div.alert').remove();
                if(responseObj.message!=undefined){
                    var success = false;
                    var warning = false;
                    $.each(responseObj.message,function(type,content){
                        if (type==="alert-error") {
                            $("#formInfoMessage").append('<div class="alert '+type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+content+'</div>');
                            $("#formInfoMessage").show();
                            $('.modal-body').scrollTop(0);
                            //ensure warning is shown inside modal window
                            warning = true;
                        } else {
                            $('#error_status').append('<div class="alert '+type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+content+'</div>');
                            success = true;
                        }
                    });

                    // if successful & no warnings, close modal
                    if (warning===false && success===true) {$('.bootbox').modal('hide')};

                } else {

                   $('.bootbox').modal('hide');
                   $('#error_status').append("<div class='alert alert-success'><button class='close' data-dismiss='alert'><i class='bi bi-x'></i></button>Successfully saved.</div>");
                }

                // do not reload html when role tab is not open
                if (document.getElementById('add_role') || (document.getElementById('add_user') && responseObj.hasOwnProperty('roles'))) {
                    $('#admin_content').html(responseObj.responseText);
                }

                $('#edit_form_wrapper').remove();
                $('#rolesModal').modal('hide');
                cfepaginatordropdown('select[data-toggle=cfe-collapse-dropdown]');
                unbindBeforeUnload();
            }
            else
            {
                $("#formInfoMessage").html('<div class="alert '+responseObj.responseText.type+'"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>'+ responseObj.responseText.content+'</div>');
                $("#formInfoMessage").show();
                $('.modal-body').scrollTop(0);
                if (responseObj.status == 'user_exists_error') {
                    $('.overwrite').show();
                }
            }
            return;
        }
    };

    $(document).ready(function() {

        /************************************************************************************/
        //              Buttons
        /************************************************************************************/

        // set hidden overwrite input value to 1 when clicked overwrite button
        $(document).on('click','.overwrite',function(event) {
            event.preventDefault();
            cleanMessages();
            const form = $(this).closest('form');
            form.find('input[name="overwrite"]').val(1);
            form.submit();
        });

        // set hidden overwrite input value to 0 when clicked regular save button
        $(document).on('click','#create_user button[type="submit"]', function() {
            $(this).closest('form').find('input[name="overwrite"]').val(0);
        });

        //Opens the edit role window
        $(document).on('click','.edit_role',function(event) {
            event.preventDefault();
            cleanMessages();
            attach_edit_form(this, $(this).attr('form'));
        });

        //submitting the create user form
        $(document).on('submit','#create_user, #edit_user',function(event) {
            event.preventDefault();
            cleanMessages();

            if (userNameValidate($('#id').val()) == false) {

                return;
            }
            $(this).ajaxSubmit(edit_form_options);
        });

        //loading the change password in admin_content
        $('a.changepassword').on('click',function(event){
            event.preventDefault();
            $("#error_status").html('');
            var path=$(this).attr('href');
            $.getJSON(path,function(data){
                $("#admin_content").html(data.responseText);
            });

        });

        //submitting the form ajaxically to the page in form action and loading the result in admin_content
        $(document).on('submit','#change_password',function(event){
            event.preventDefault();
            $(this).ajaxSubmit(options);
        });


        //loading the  role create page in the  admin area ajaxcially
        $(document).on('click','#add_role, .add_role',function(event){
            event.preventDefault();
            attach_edit_form(this, 'role', 'Add role');
        });

        $(".user_roles_management").on("click", "a.remove", function(event){
                event.preventDefault();

                var msg;

                var args=[];
                args.domElementId = options.target;
                args.link = $(event.currentTarget).attr('href');
                args.link2 = MP_SITE_URL + $(event.currentTarget).attr('action-link');
                msg = 'Are you sure you want to remove this '+ $(event.currentTarget).attr('entityName') + '?';

                $("#error_status").html('');

                $('#confirmation').text(msg);
                $('#confirmation').show();

                // create buttons - cancel and confirm
                var cancelBtn  = generateDialogBtn('Cancel', $confirmation);


                var confirmBtn = generateDialogBtn('Confirm', $confirmation, loadContent, args);

                $confirmation.dialog("option", "buttons", [cancelBtn,confirmBtn] );
                $confirmation.dialog("option", "title", "Are you sure?");
                $confirmation.dialog("open");
                $('.ui-icon-closethick').html('×');
            });



        //loading all the pages in admin content after clicking the items in admin index menu
        $('.admin_menu li a').click(function(event){
            event.preventDefault();
            var path=$(this).attr('href');

            $("#error_status").html('');
            $('#edit_form_wrapper').html('');
            $("#admin_content").load(path,function(){cfepaginatordropdown('select[data-toggle=cfe-collapse-dropdown]')});
            $(this).parent().addClass('ui-tabs-selected ui-state-active ').siblings().removeClass('ui-tabs-selected ui-state-active');
            cleanMessages();
        });

        //closing the add/edit form
        $(document).on('click','.btnCancel',function(event){
           event.preventDefault();
           $('#edit_form_wrapper').remove();
            unbindBeforeUnload();
           $('#rolesModal').modal('hide');
        });

        $(document).on('click','#super_role_btn',function(event){
            $('.role_btn').trigger('click');
        });


        //create a new role form the page loaded
        $(document).on('submit','#create_role, #edit_role',function(event){
            event.preventDefault();
            cleanMessages();

            if (roleNameValidate($('#id').val()) == false || roleDescriptionValidate($('#description').val())==false) {

                return;
            }

            if (includeClassValidate() == false) {

                return;
            }

            if (roleIncludeExcludeValidate() == false)
            {
                var $form = $(this);

            }
            else
            {
                $(this).ajaxSubmit(edit_form_options);
            }
        });


        $(document).on('click','addClassRegexp',function(e){
            if($('#classRegexpText').val() != '') {
                $('#classList').prepend('<li class=""><span>' + $('#classRegexpText').val() + '</span></li>' );
                $('#classRegexpText').css('border', 'inherit');
            }
            else {
                $('#classRegexpText').css('border', '1px solid red');
            }
        });

        /************************************************************************************/




        /*********************** common functions  ****************************************************************/


        function includeClassValidate() {
            if (getInputValues('#classes_inc_exc .includes').length == 0 )
            {
                $('#formInfoMessage').html('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>Role must have at least one <b>include</b> class.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }
        }

        function roleIncludeExcludeValidate()
        {
           if (getInputValues('#classes_inc_exc .includes').length == 0 && getInputValues('#classes_inc_exc .excludes').length == 0)
            {
                $('#formInfoMessage').html('<div class="alert alert-info"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>This role will allow complete reporting permissions for all hosts, is this what you wanted? If not, please fill in a host class regular expression.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }

            return true;
        }

        function attach_edit_form(elem, form, title = 'Edit role') {

            var parent = $('#rolesModal .modal-body');

            //delete element
            if($("#edit_form_wrapper").length) {
                $("#edit_form_wrapper").remove();
            }

            $('<div id="edit_form_wrapper"><div id="edit_form"></div></div>').appendTo(parent);


            $("#error_status").html('');
            $("#error_status1").html('');
            var path = $(elem).attr('href');

            load_edit_form(path, form, title);
        }

        function load_edit_form(path, form, title) {

            $("#edit_form").load(path,function(res){
                $("#edit_form").html(res).slideDown('slow',  function() {

                    if (form == 'role')
                    {
                        addFinders();
                    }
                    else
                    {
                        bindSortable('roleslist', new Array('roles'))
                    }
                });

                $('#rolesModal h2').text(title);
                $('#rolesModal').modal('show');

            });
        }

        function getSelectedCheckboxes(parentId) {
            var res = [];
            $('#' + parentId + ' input[type="checkbox"]:checked').each(function() {
                res.push($(this).val());
            });

            return res;
        }

        function getInputValues(selector) {
            var res = [];
             $(selector + ' input[type="text"]').each(function() {
                 if($(this).val() != '')
                    res.push($(this).val());
            });

            return res;
        }

        function addFinders() {
            $('#classes_inc_exc').contextfinder({
                finder_title: 'Classes',
                baseUrl: '<?php echo site_url() ?>',
                embedded: true,

                include_field_name: 'crxi',
                exclude_field_name: 'crxx',
                useFinder: 'classfinder',

                HTML_ID: 'classes_inc_exc',
                setContextClbkFnc:function() {
                },
                complete:function(event,data){
                }
            });
        }

        function userNameValidate(name) {
            var name = $.trim(name);

            if (name.length == 0) {
                $('#formInfoMessage').append('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>You must enter user name.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }

            var userRegex = /^[A-Za-z0-9_.\-\.]+$/; //letters, numbers, underscore, dashes and dots

            if (!userRegex.test(name)) {
                $('#formInfoMessage').append('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>Please use only letters, dots, dashes, numbers and underscore for user name.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }
        }


        function roleNameValidate(name) {
            var name = $.trim(name);

            if (name.length == 0) {
                $('#formInfoMessage').append('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>You must add a name to the role.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }

            var roleRegex = /^[A-Za-z0-9_ \-\.]+$/; //letters, numbers, dashes, dots, spaces and underscores

            if (!roleRegex.test(name)) {
                $('#formInfoMessage').append('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>Please use only letters, spaces, dashes, numbers, dots and underscores for Role name.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }
        }

        function roleDescriptionValidate(name) {
            var name = $.trim(name);

            if (name.length == 0) {
                $('#formInfoMessage').append('<div class="alert alert-error"><button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>You must add a description to the role.</div>');
                $('#formInfoMessage').show();
                $('.modal-body').scrollTop(0);
                return false;
            }
        }
    });  // end of document.ready

    /*-------------------------------------------------------------------------------------------------*/




    function loadContent(args) {
        $(args.domElementId).load(args.link,
        function(responseText, textStatus, XMLHttpRequest) {

            switch (XMLHttpRequest.status) {
                case 200: reloadTable(args.link2); break;
                case 401:
                case 404:
                    $('#error_status').html('<p class="error">' + responseText + '</p>');
                    break;
                default:
                    $('#error_status').html('<p class="error">' + '<?php echo $this->lang->line('500_error'); ?>' + '</p>');
                    break;
                }
            }
        );
        }

    function reloadTable(link) {
        $('#admin_content').load(link);
    }

        /****************************** DIALOG **********************************************/

        //dialog object
        var $confirmation = $('#confirmation').dialog({
            autoOpen: false,
            modal: true,
            data: '',
            resizable: false,
            beforeClose: '',
            buttons: [],
            create: function(event, ui) {
                // weird way to get clicked button
                $(".ui-dialog-buttonset button").on("click", function(event, self){
                    $confirmation.dialog.data = {clicked: $(this).attr('name')};
                });
            },
            open: function()
            {
                $(this).parent().find('.ui-dialog-buttonpane').find('button:last').focus()
            }
        });


        function generateDialogBtn(label, dialogObj, callbackFnc, args) {
           var btn_class="btn btn-large";
           if(label=="Confirm"){
               btn_class+=" btn-primary"
           }
            var btn = {
                text: label,
                value: label,
                name: label,
               "class":btn_class,
                click: function()
                {
                    dialogObj.dialog('close');
                    //form.ajaxSubmit(options);
                    if (callbackFnc != '' && $.isFunction(callbackFnc)) {
                        callbackFnc.call(this, args);
                    }
                }
            };
            return btn;
        }

        function cleanMessages()
        {
            $('#formInfoMessage').html('');
            $('#infoMessage').html('');
            $('#error_status').html('');
            $('#error_status1').html('');
        }

</script>