<?php

/**
 * Class FormatInventoryFilterFactory
 */
class FormatInventoryFilterFactory
{
    /**
     * Default type of variable
     */
    const DEFAULT_TYPE = 'string';

    /**
     * Get manager according to type.
     *
     * @param string $type
     * @return FormatInventoryFilterInterface
     * @throws \Exception
     */
    public static function getImplementation($type = self::DEFAULT_TYPE){
        try {
            $className =   ucfirst($type) . 'Implementation';
            if(class_exists($className)){
                $implementation = new $className();
            }else
            {
                $implementation = new DefaultImplementation();
            }
        } catch (\Exception $e) {
            throw $e;
        }
        return $implementation;
    }
}