<?php

/**
 * @uri /rbac/user-permissions
 */
class RbacUserPermissions extends CfProtectedResource
{
    private $roles;
    private $cfRbac;

    function __construct($parameters = array())
    {
        parent::__construct($parameters);

        $cfUser = new CfUsers($this->username);
        $this->roles = $cfUser->getUserRoles();
        $this->cfRbac = new CfRBAC();
    }


    function get($request)
    {
        $response = new Response($request);
        $response->code = Response::OK;
        $permissions = $this->cfRbac->getPermissionsByRoles($this->roles);
        $response->body = json_encode($permissions);

        return $response;
    }

}


/**
 * @uri /rbac
 */
class RbacPermissionList extends CfProtectedResource
{
    private $cfRbac;

    function __construct($parameters = array())
    {
        parent::__construct($parameters);
        $this->cfRbac = new CfRBAC();
    }

    /**
     * @param $request
     *
     * @rbacName Get permission list
     * @rbacGroup RBAC
     * @rbacAlias rbacPermissionList.get
     *
     * @return Response
     */
    function get($request)
    {
        $response = new Response($request);
        $response->code = Response::OK;
        $permissions = $this->cfRbac->getPermissions();
        $response->body = json_encode($permissions);

        return $response;
    }

}
