<div class="settingsPage">

    <div class="left-column">
        <?php include('settingsSideBar.php'); ?>
    </div>

    <div class="right-column">

        <div class="pageTitle">
            <h1><span>Authentication settings</span></h1>
        </div>

        <div class="pullTop">

            <?php

            if (($this->session->flashdata('message')) || (isset($message) && is_array($message))) {
                $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
                $content = $flashMessage['content'];
                $content_class = $flashMessage['type'];
                ?>
                <?php if (!empty($content)) { ?>
                    <div style="margin-top: 13px;">
                        <div class="alert <?php echo $content_class; ?>">
                            <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                            <?php echo $content; ?>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>

        <form class="form-horizontal">

            <div class="control-group">
                <label class="control-label" for="authentication">Authentication method</label>
                <div class="controls">
                    <label class="radio inline">
                        <?php
                        $elem = array(
                            'name' => 'mode',
                            'id' => 'mode1',
                            'class' => 'radio',
                            'value' => 'internal',
                            'checked' => (isset($mode) && $mode === 'internal' ? TRUE : $this->form_validation->set_radio('mode', 'internal'))
                        );
                        echo form_radio($elem);
                        ?>
                        Internal
                    </label>

                    <label for="mode" class="radio inline">

                        <?php
                        $elem = array(
                            'name' => 'mode',
                            'id' => 'mode2',
                            'class' => 'radio',
                            'value' => 'ldap',
                            'checked' => (isset($mode) && $mode === 'ldap' ? TRUE : $this->form_validation->set_radio('mode', 'ldap'))
                        );
                        echo form_radio($elem);
                        ?>
                        LDAP
                    </label>
                </div>
            </div>
        </form>


        <div class="ldap-form">

            <h5 class="activate-msg" <?php if ($is_ldap_available) { ?> style="display: none" <?php } ?>>LDAP API settings are incorrect.
                See application log for details.</h5>

            <?php
            $attributes = array('class' => 'form-horizontal confirm-before-leave', 'id' => 'mpsettings', 'autocomplete' => "off");
            echo form_open_multipart('settings/authentication', $attributes);
            ?>
            <fieldset id="ldapsettings" class="border-bottom">
                <div class="control-group required">
                    <label class="control-label" for="domain_controller">LDAP Host</label>
                    <div class="controls">
                        <input id="domain_controller" type="text" name="domain_controller" class="input-xlarge"
                               value="<?= $domain_controller ?? '' ?>"/>
                        <p class="help-block"> <?php echo tooltip('tooltip_host_name'); ?></p>
                    </div>
                </div>

                <div class="control-group required">
                    <label class="control-label" for="port">Port</label>
                    <div class="controls">
                        <input id="port" type="text" name="port" class="input-xlarge" value="<?= $port ?? '' ?>"/>
                    </div>
                </div>

                <div class="control-group">
                    <label class="control-label" for="encryption">Encryption</label>
                    <div class="controls">
                        <label class="radio inline">
                            <?php
                            $elem = array(
                                'name' => 'encryption',
                                'id' => 'sec1',
                                'class' => 'radio',
                                'value' => 'plain',
                                'checked' => (isset($encryption) && $encryption === 'plain' ? TRUE : '')
                            );
                            echo form_radio($elem);
                            ?>
                            None
                        </label>

                        <label for="encryption" class="radio inline">
                            <?php
                            $elem = array(
                                'name' => 'encryption',
                                'id' => 'sec2',
                                'value' => 'ssl',
                                'class' => 'radio',
                                'checked' => (isset($encryption) && $encryption === 'ssl' ? TRUE : '')
                            );
                            echo form_radio($elem);
                            ?>
                            SSL
                        </label>

                        <label for="encryption" class="radio inline">
                            <?php
                            $elem = array(
                                'name' => 'encryption',
                                'id' => 'sec3',
                                'value' => 'tls',
                                'class' => 'radio',
                                'checked' => (isset($encryption) && $encryption === 'tls' ? TRUE : '')
                            );
                            echo form_radio($elem);
                            ?>
                            STARTTLS
                        </label>
                    </div>
                </div>
                <div class="control-group required">
                    <label class="control-label" for="base_dn">Base DN</label>
                    <div class="controls">
                        <input id="base_dn" type="text" name="base_dn"
                               class="input-xlarge" value="<?= $base_dn ?? '' ?>"/>
                        <p class="help-block"> <?php echo tooltip('tooltip_base_dn'); ?></p>
                    </div>
                </div>

                <div class="control-group required">
                    <label class="control-label" for="host">Login attribute</label>
                    <div class="controls">
                        <input id="login_attribute" type="text" name="login_attribute" class="input-xlarge"
                               value="<?= $login_attribute ?? '' ?>"/>
                        <p class="help-block"><?php echo tooltip('tooltip_login_attr'); ?></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="host">LDAP filter</label>
                    <div class="controls">
                        <input id="ldap_filter" type="text" name="ldap_filter" class="input-xlarge"
                               value="<?= $ldap_filter ?>"/>
                        <p class="help-block"><?php echo tooltip('tooltip_ldap_search_filter'); ?></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="anonymous_bind">Anonymous Bind</label>
                    <div class="controls">
                        <input id="anonymous_bind" type="checkbox" name="anonymous_bind" class="input-xlarge"
                        <?php if ($anonymous_bind) { ?>checked<?php } ?>
                        onchange="
                        if (this.checked) {
                          $('.ldap-credentials').hide();
                          $('#admin_username').val('');
                          $('#admin_password').val('');
                        } else {
                          $('.ldap-credentials').show();
                        }"
                        value="true" />
                    </div>
                </div>
                <div class="control-group ldap-credentials" <?php if ($anonymous_bind) { ?>style="display:none"<?php } ?>>
                    <label class="control-label" for="admin_username">LDAP bind user name</label>
                    <div class="controls">
                        <input id="admin_username" type="text" name="admin_username" class="input-xlarge"
                               value="<?= $admin_username ?? '' ?>"/>
                        <p class="help-block"><?php echo tooltip('tooltip_external_admin_username'); ?></p>
                    </div>
                </div>

                <div class="control-group ldap-credentials" <?php if ($anonymous_bind) { ?>style="display:none"<?php } ?>>
                    <label class="control-label" for="admin_password">LDAP bind password</label>
                    <div class="controls">
                        <input id="admin_password" type="password" autocomplete="new-password" class="input-xlarge"
                               onchange="this.setAttribute('name', 'admin_password')"
                               placeholder="<?= $admin_password ?? '' ?>"/>
                        <?php $this->load->view('common/show-password-btn.php'); ?>
                    </div>
                </div>
                <hr />
                <h3 class="margin-bottom-large">LDAP groups syncing</h3>
                <div class="control-group">
                    <label class="control-label" for="enable_ldap_role_syncing">Enable syncing of LDAP groups and MP roles</label>
                    <div class="controls">
                        <input id="enable_ldap_role_syncing"
                               type="checkbox"
                               name="settings[ldap_enable_role_syncing]"
                               onchange="$('.ldap_group_additional_fields').toggle()"
                               class="input-xlarge"
                               value="1"
                               <?= isset($settings['ldap_enable_role_syncing']) && $settings['ldap_enable_role_syncing'] ? 'checked="checked"' : '' ?>
                        />
                    </div>
                </div>
                <div class="ldap_group_additional_fields"
                     style="<?= !isset($settings['ldap_enable_role_syncing']) || $settings['ldap_enable_role_syncing'] !== true ? 'display: none' : '' ?>">
                    <div class="control-group">
                        <label class="control-label" for="group_attribute">User group attribute</label>
                        <div class="controls">
                            <input id="group_attribute" type="text" name="group_attribute" class="input-xlarge"
                                   value="<?= $group_attribute ?? '' ?>"/>
                            <p class="help-block">Group attribute of LDAP user entry, e.g memberof</p>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="roles_list_to_sync">List of groups to sync (names must
                            match in LDAP/MP)</label>
                        <div class="controls">
                        <textarea id="roles_list_to_sync"
                                  type="text"
                                  rows="6"
                                  name="settings[ldap_roles_list_to_sync]"
                                  class="input-xlarge"><?= $settings['ldap_roles_list_to_sync'] ?></textarea>
                            <div class="help-block">Each role on a new line</div>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="perform_sync_on_login">Perform sync on every login</label>
                        <div class="controls">
                            <input id="perform_sync_on_login"
                                   type="checkbox"
                                   name="settings[ldap_perform_sync_on_login]"
                                   class="input-xlarge"
                                   value="1"
                                   onchange="$('.remove-groups').toggle()"
                                <?= isset($settings['ldap_perform_sync_on_login']) && $settings['ldap_perform_sync_on_login'] ? 'checked="checked"' : '' ?>
                            />
                        </div>
                    </div>
                    <div class="control-group remove-groups"
                         style="<?= !isset($settings['ldap_perform_sync_on_login']) || $settings['ldap_perform_sync_on_login'] !== true ? 'display: none' : '' ?>">
                        <label class="control-label" for="remove_ldap_role_on_syncing">Remove groups based on LDAP
                            roles</label>
                        <div class="controls">
                            <input id="remove_ldap_role_on_syncing"
                                   type="checkbox"
                                   name="settings[ldap_remove_role_on_syncing]"
                                   class="input-xlarge"
                                   value="1"
                                <?= isset($settings['ldap_remove_role_on_syncing']) && $settings['ldap_remove_role_on_syncing'] ? 'checked="checked"' : '' ?>
                            />
                        </div>

                    </div>
                    <p class="help-block">
                        Groups will only be added / removed based on the list of groups / roles, all others are
                        untouched.
                    </p>
                </div>
                <?php echo form_submit(array(
                    'name' => 'submit',
                    'class' => 'btn apply-button btn-primary btn-large pull-right',
                    'value' => 'Apply'
                )); ?>
            </fieldset>

            <?php echo form_close(); ?>

        </div>
    </div>
</div>
<?php if (!$is_ldap_available) { ?>
    <script>
        $('#mpsettings input').attr('disabled', 'disabled');
    </script>
<?php } ?>
<script src="/scripts/authentication-settings.js"></script>
