'use strict';

var inventoryFilterServiceClass = Class.extend({
    processFilters: function (filters) {
        var processedFilters = {};

        if (filters === null || filters.length === 0) {
            return null;
        }

        angular.forEach(filters, function (value, key) {
            var processedFilterItem = this.processFilterItem(value);
            this.combineFilters(processedFilters, processedFilterItem);
        }, this);
        return Object.keys(processedFilters).length !== 0 ? processedFilters : null;
    },

    processHostsFilters: function (hostsFilters) {
        let processedFilters = {};
        if (hostsFilters && Object.keys(hostsFilters.includes).length > 0) {
            processedFilters.includes = {
                type: 'hostkey',
                data: Object.keys(hostsFilters.includes)
            }
        }

        if (hostsFilters && Object.keys(hostsFilters.excludes).length > 0) {
            processedFilters.excludes = {
                type: 'hostkey',
                data: Object.keys(hostsFilters.excludes)
            }
        }
        return Object.keys(processedFilters).length > 0 ? processedFilters : null;
    },

    processClassFilters: function (filters) {
        let classes = [];

        if (filters === null || filters.length === 0) {
            return classes;
        }

        angular.forEach(filters, function (value) {
            if (value.type === 'class') {
                classes.push(value.value);
            }
        });

        return classes;
    },

    combineFilters: function (processedFilters, processedFilterItem) {
        if (typeof processedFilterItem !== 'object' || processedFilterItem === null) {
            return ;
        }
        var filterKey = Object.keys(processedFilterItem)[0];
        if (processedFilters.hasOwnProperty(filterKey)) {
            var combineFilters = {};
            var currentValue = processedFilters[filterKey];
            let condition = Object.keys(processedFilterItem[filterKey])[0];
            //set value as array in case of filters with the same attribute naprocessFiltersme and condition
            if (processedFilters[filterKey].hasOwnProperty(condition)) {
                let arrayValue = Array.isArray(processedFilters[filterKey][condition]) ? processedFilters[filterKey][condition] : [processedFilters[filterKey][condition]];
                arrayValue.push(processedFilterItem[filterKey][condition]);
                processedFilterItem[filterKey][condition] = arrayValue;
            }
            Object.assign(combineFilters, currentValue);
            Object.assign(combineFilters, processedFilterItem[filterKey]);
            processedFilters[filterKey] = combineFilters;
        } else {
            Object.assign(processedFilters, processedFilterItem);
        }
    },

    /**
     * Process filter item according to type
     * @param filterItem
     * @returns object|null
     */
    processFilterItem: function (filterItem) {
        if (filterItem.value === undefined || filterItem.type === 'class') {
            return null;
        }

        var filterItemObj = {},
            filterItemProcessed = {},
            attributeName = filterItem['attribute_name'].replace('attribute_name=', '');


        switch (filterItem.type) {
            case 'slist':
                filterItemProcessed = this._processlist(filterItem);
                break;
            case 'string':
                filterItemProcessed = this._processString(filterItem);
                break;
            case 'int':
            case 'real':
                filterItemProcessed = this._processNumeric(filterItem);
                break;
            case 'date':
                filterItemProcessed = this._processDate(filterItem);
                break;
            case 'context':
                filterItemProcessed = this._processString(filterItem);
                break;
        }

        filterItemObj[attributeName] = filterItemProcessed;

        return filterItemObj;
    },

    /**
     * Process filter item for type SList
     * @param filter
     * @returns object|null
     */
    _processlist: function (filter) {
        var value = filter.value.replace(',', '%'),
            realCondition = '',
            resultObj = {};

        switch (filter.condition) {
            case '=':
                realCondition = INVENTORY_FILTER_OPERATORS['matches'];
                break;
            case '!=':
                realCondition = INVENTORY_FILTER_OPERATORS['not_match'];
                break;
            default:
                realCondition = INVENTORY_FILTER_OPERATORS[filter.condition];
                break;
        }

        resultObj[realCondition] = value;

        return resultObj
    },

    /**
     * Process filter item for type String
     * @param filter
     * @returns object
     */
    _processString: function (filter) {
        var value = filter.value,
            resultObj = {};
        var realCondition = INVENTORY_FILTER_OPERATORS[filter.condition];
        resultObj[realCondition] = value;

        return resultObj
    },

    /**
     * Process filter item for type Numeric
     * @param filter
     * @returns object
     */
    _processNumeric: function (filter) {
        var value = filter.value,
            realCondition = '',
            resultObj = {};

        realCondition = INVENTORY_FILTER_OPERATORS[filter.condition];

        resultObj[realCondition] = value;

        return resultObj
    },

    /**
     * Process filter item for type Date
     * @param filter
     * @returns object
     */
    _processDate: function (filter) {
        var value = filter.value,
            realCondition = '',
            resultObj = {};

        realCondition = INVENTORY_FILTER_OPERATORS[filter.condition];

        resultObj[realCondition] = value;

        return resultObj
    }

});

(function () {
    var inventoryFilterServiceClassProvider = Class.extend({
        instance: new inventoryFilterServiceClass(),
        $get: [function () {
            return this.instance;
        }]
    });

    angular.module('inventoryFilterServiceModule', [])
        .provider('inventoryFilterService', inventoryFilterServiceClassProvider);

}());