/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for hubManagement
 *
 **/


var cmdbServiceClass = Class.extend({
    MODULE_URL: MP_SITE_URL + '/cmdb',
    ALLOWED_KEYS: ['value', 'comment', 'tags', 'name', 'type'],
    getItems: function (hostkey) {
        let url = `${this.MODULE_URL}/items/${hostkey}`;
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },
    getItem: function (hostkey, type, name) {
        let url = `${this.MODULE_URL}/item/${hostkey}/${type}/${name}/`;
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },
    _filterValue: function (value) {
        let filteredValues = {};
        this.ALLOWED_KEYS.forEach(key => {
            if (value.hasOwnProperty(key)) {
                filteredValues[key] = value[key];
            }
        });
        return filteredValues;
    },
    createItem: function (hostkey, type, name, value) {
        let url = `${this.MODULE_URL}/item/${hostkey}/${type}/${name}/`;

        return this.$http({
            method: 'POST',
            data: $.param({data: JSON.stringify(this._filterValue(value))}),
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url
        });
    },
    updateItem: function (hostkey, type, name, value) {
        let url = `${this.MODULE_URL}/item/${hostkey}/${type}/${name}/`;

        return this.$http({
            method: 'PUT',
            data: $.param({data: JSON.stringify(this._filterValue(value))}),
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url
        });
    },
    deleteItem: function (hostkey, type, name) {
        let url = `${this.MODULE_URL}/item/${hostkey}/${type}/${name}/`;
        return this.$http({
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            transformRequest: angular.identity
        });
    },

});

(function () {
    var cmdbServiceServiceProvider = Class.extend({
        instance: new cmdbServiceClass(),
        $get: ['$http', '$httpParamSerializer', function ($http, $httpParamSerializerJQLike) {
            this.instance.$http = $http;
            this.instance.$httpParamSerializerJQLike = $httpParamSerializerJQLike;
            return this.instance;
        }]
    });

    angular.module('cmdbServiceServiceModule', [])
        .provider('cmdbService', cmdbServiceServiceProvider);
}());
