<div class="padding_5 cmdb">
    <span ng-init='permissions=<?= json_encode([
            'create' => isActionAllowed('cmdb.create'),
            'delete' => isActionAllowed('cmdb.delete'),
            'update' => isActionAllowed('cmdb.update'),
            'view' => isActionAllowed('cmdb.get'),
          ])
    ?>'>
    </span>
    <div class="flex flex-space-between flex--align_center">
        <h4>Host specific data</h4>
        <div ng-if="permissions.create" class="suggestions">
            <span class="link" ng-click="suggestions.opened = !suggestions.opened">Suggestions
                <img ng-class="{'rotated': suggestions.opened }" src="/images/arrow-down.svg"/></span>
            <div class="dropdown-selector" ng-show="suggestions.opened">
                <div class="dropdown-selector_body">
                    <div
                            ng-class="{'selected' :  suggestion.name === suggestions.selected.name, 'disabled': suggestion.disabled}"
                            ng-click="suggestions.selected = suggestion.disabled ? suggestions.selected : suggestion"
                            class="dropdown-selector_item tooltip-box"
                            ng-repeat="suggestion in suggestions.list track by $index">
                        {{ suggestion.name }}
                        <span class="tooltip-text">
                            {{ suggestion.tooltip }}
                        </span>
                    </div>
                </div>
                <div class="dropdown-selector_footer">
                    <div class="flex flex--end flex--align_center">
                        <button ng-click="suggestions.opened = false;suggestions.selected = {};"
                                class="btn-transparent btn-gray margin-right-small">
                            Cancel
                        </button>
                        <button ng-disabled="!suggestions.selected.name" ng-click="addSuggestion(suggestions.selected)"
                                class="btn-primary btn btn-large add-suggestion">
                            Add
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="cmdb--variables card margin-top-small">
        <div class="card-header">Variables</div>
        <div class="card-body">
            <div class="items">
                <div class="item" ng-repeat="item in filtered.variables track by $index"
                     ng-class="{'item-last': $last, 'highlighted': highlight.name === item.name}">
                    <div ng-if="editing.variables.index !== $index"
                         ng-class="{'disabled': (editing.variables.index!== undefined && editing.variables.index !== $index) || new.variables !== null}">
                        <div class="flex margin-bottom-small">
                            <div class="item-name cmdb-text-container">
                                <div class="tooltip-box">
                                    <span class="cmdb-text">{{ item.name }}</span>
                                    <span class="tooltip-text">
                                        <div ng-repeat="(key,value) in tooltippedName(item.name) track by $index">{{ key }}: {{ value }}</div>
                                    </span>
                                </div>
                            </div>
                            <div class="flex flex-space-between flex-grow flex--align_start relative cmdb-text-container">
                                <span class="cmdb-text item-value"
                                      ng-bind-html="renderContent(item.value, item.type)"></span>
                                <div class="item-actions">
                                    <button class="btn-transparent" ng-if="permissions.update || permissions.delete" ng-click="addOpenedClass($event)">...</button>
                                    <div class="item-actions-dropdown">
                                        <button ng-if="permissions.update" ng-click="editVariable($index)" class="btn-transparent">
                                            <i class="icon-pencil edit"></i> Edit
                                        </button>
                                        <button ng-if="permissions.delete" ng-click="delete('variables', item.name, hostkey)"
                                                class="btn-transparent">
                                            <i class="icon-trash"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex">
                            <div class="item-tags flex flex-wrap">
                                <span ng-repeat="tag in item.tags track by $index" ng-bind-html="tag"></span>
                            </div>
                            <div class="tooltip-box cmdb-text-container">
                                <div class="item-description cmdb-text" ng-bind-html="item.comment">
                                </div>
                                <span ng-class="{'hide': item.comment.length < 111 }"
                                      class="tooltip-text" ng-bind-html="item.comment"></span>
                            </div>
                        </div>
                    </div>
                    <form name="form" ng-if="editing.variables.index === $index">
                        <div class="flex flex-space-between margin-bottom-small"
                             ng-class="{ 'flex--align_start': totextarea}">
                            <label class="nameLabel">
                                <div>Name *</div>
                                <input name="name"
                                       ng-pattern="namePattern"
                                       required
                                       ng-maxlength="maxNameLength"
                                       ng-model="editing.variables.var.name"
                                       initvalue="{{filtered.variables[editing.variables.index].name}}"
                                       itemtype="variables"
                                       hostkey="{{hostkey}}"
                                       name-exists
                                />
                                <div class="validation-error" ng-show="form.name.$error.pattern">Alphanumeric and
                                    underscore are only allowed
                                </div>
                                <div class="validation-error"
                                     ng-show="form.name.$error.required">Please enter the name
                                </div>
                                <div class="validation-error" ng-show="form.name.$error.nameExists">Name already
                                    exists
                                </div>
                                <div class="validation-error" ng-show="form.name.$error.maxlength">
                                    Max length ({{maxNameLength}}) is exceeded
                                </div>
                            </label>
                            <label for="editingValue" class="flex flex-space-between flex--align_end flex-grow relative margin-bottom"
                                   ng-class="{ 'flex--align_start': totextarea.value}">
                                <div>
                                    <div>Value *</div>
                                    <select ng-model="editing.variables.type"
                                            ng-options="key as value for (key , value) in types">
                                    </select>
                                </div>
                                <div class="flex-grow">
                                    <input id="editingValue" name="value"
                                           ng-focus="inputFocused($event, 'value', editing.variables.var)"
                                           ng-maxlength="maxValueLength"
                                           ng-hide="totextarea.value || (editing.variables.type != 'Array' && editing.variables.type != 'Object')"
                                           ng-value="renderContent(editing.variables.var.value, editing.variables.type)"
                                    />
                                    <input id="editingValue"
                                           not-cfe-variable
                                           ng-focus="inputFocused($event, 'value', editing.variables.var)"
                                           ng-maxlength="maxValueLength"
                                           ng-hide="totextarea.value || editing.variables.type == 'Array' || editing.variables.type == 'Object'"
                                           ng-value="renderContent(editing.variables.var.value, editing.variables.type)"
                                           ng-model="editing.variables.var.value"
                                           name="inputValue"
                                           ng-model-options="{ allowInvalid: true }"
                                    />
                                    <textarea placeholder="Press enter to add new value"
                                              rows="3" ng-blur="textAreaBlur($event, 'value', editing.variables.var, form)"
                                              ng-maxlength="maxValueLength"
                                              ng-show="totextarea.value"
                                              valid-json
                                              type="{{editing.variables.type}}"
                                              name="value"
                                              ng-model="editing.variables.var.value"></textarea>

                                    <div class="validation-error" ng-show="form.value.$error.inValidJson">
                                        Is not valid JSON object or array
                                    </div>
                                    <div class="validation-error" ng-show="form.inputValue.$error.CFEVariableDetected">
                                        CFEngine variables are not allowed
                                    </div>
                                    <div class="validation-error" ng-show="form.inputValue.$error.maxlength">
                                        Max length ({{maxValueLength}}) is exceeded
                                    </div>
                                </div>

                            </label>
                        </div>
                        <div class="flex">
                            <label class="nameLabel">
                                <div>Tags</div>
                                <input ng-init="editing.variables.var.tags = editing.variables.var.tags || []"
                                       ng-focus="inputFocused($event, 'tags', editing.variables.var)"
                                       ng-hide="totextarea.tags"
                                       ng-value="editing.variables.var.tags.join(', ')"
                                       ng-model="editing.variables.var.tags"
                                       ng-maxlength="maxValueLength"
                                       not-cfe-variable
                                       name="tags" />
                                <textarea placeholder="Press enter to add new tags (optional)"
                                          style="width: 90%;" rows="3"
                                          ng-blur="textAreaBlur($event, 'tags', editing.variables.var)"
                                          ng-show="totextarea.tags"
                                          ng-maxlength="maxValueLength"
                                          ng-model="editing.variables.var.tags"></textarea>
                                <div class="validation-error" ng-show="form.tags.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="form.tags.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                            <label class="flex-grow">
                                <div>Description</div>
                                <input style="width: 100%;" ng-maxlength="maxValueLength"
                                       ng-model="editing.variables.var.comment" name="description" not-cfe-variable/>
                                <div class="validation-error" ng-show="form.description.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="form.description.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                        </div>
                        <div class="flex flex--end flex--align_center margin-top">
                            <button type="button" ng-click="cancelEditing()"
                                    class="btn-transparent cancel margin-right-small">
                                Cancel
                            </button>
                            <button
                                type="button"
                                    ng-disabled="(form.$error | objectLength) > 0"
                                    ng-click="save('variables', filtered.variables[editing.variables.index].name, editing.variables.var, false, filtered.variables[editing.variables.index].name !== editing.variables.var.name)"
                                    class="btn-primary btn btn-large">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
                <div ng-if="new.variables !== null" class="item item-add">
                    <form name="form">
                        <div class="flex flex-space-between margin-bottom-small"
                             ng-class="{ 'flex--align_start': totextarea}">
                            <label class="nameLabel">
                                <div>Name *</div>
                                <input name="name"
                                       ng-maxlength="maxNameLength"
                                       autocomplete="off"
                                       required
                                       placeholder="Data name"
                                       hostkey="{{hostkey}}"
                                       itemtype="variables"
                                       name-exists
                                       ng-pattern="namePattern"
                                       ng-model="new.variables.name"/>
                                <div class="validation-error" ng-show="form.name.$error.pattern">Alphanumeric and
                                    underscore are only allowed
                                </div>
                                <div class="validation-error" ng-show="form.name.$error.maxlength">
                                    Max length ({{maxNameLength}}) is exceeded
                                </div>
                                <div class="validation-error"
                                     ng-show="form.name.$error.required">Please enter the name
                                </div>
                                <div class="validation-error" ng-show="form.name.$error.nameExists">Name already
                                    exists
                                </div>
                            </label>
                            <div class="flex-grow">
                            <label for="addingValue" class="flex flex-space-between flex--align_end flex-grow relative margin-bottom"
                                 ng-class="{ 'flex--align_start': totextarea.value}">
                                <div class="typeLabel">
                                    <div>Value *</div>
                                    <select ng-model="new.variables.type"
                                            ng-options="key as value for (key , value) in types">
                                    </select>
                                </div>
                                <input id="addingValue" placeholder="Value" ng-focus="inputFocused($event, 'value', new.variables)"
                                       ng-hide="totextarea.value || (new.variables.type != 'Array' && new.variables.type != 'Object')"
                                       ng-value="renderContent(new.variables.value, new.variables.type)"
                                       ng-maxlength="maxValueLength"

                                />
                                <input id="addingValue" placeholder="Value" ng-focus="inputFocused($event, 'value', new.variables)"
                                       ng-hide="totextarea.value || new.variables.type == 'Array' || new.variables.type == 'Object'"
                                       ng-model="new.variables.value"
                                       ng-maxlength="maxValueLength"
                                       not-cfe-variable
                                       name="inputValue"
                                       ng-model-options="{ allowInvalid: true }"
                                />
                                <textarea placeholder="Press enter to add new value"
                                          rows="3" ng-blur="textAreaBlur($event, 'value', new.variables, form)"
                                          ng-show="totextarea.value"
                                          name="value"
                                          ng-maxlength="maxValueLength"
                                          ng-model="new.variables.value"
                                          valid-json
                                          type="{{ new.variables.type }}"
                                          >

                                </textarea>

                            </label>
                                <div class="validation-error" ng-show="form.value.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                                <div class="validation-error pull-right" ng-show="form.value.$error.inValidJson">
                                    Is not valid JSON object or array
                                </div>
                                <div class="validation-error pull-right" ng-show="form.inputValue.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                            </div>
                        </div>
                        <div class="flex">
                            <label class="nameLabel">
                                <div>Tags</div>
                                <input placeholder="Enter tags" ng-focus="inputFocused($event, 'tags', new.variables)"
                                       ng-hide="totextarea.tags"
                                       ng-value="new.variables.tags.join(', ')"
                                       ng-model="new.variables.tags"
                                       ng-maxlength="maxValueLength"
                                       not-cfe-variable
                                       name="tags"
                                />
                                <textarea placeholder="Press enter to add new tags (optional)"
                                          style="width: 90%;" rows="3"
                                          ng-blur="textAreaBlur($event, 'tags', new.variables)"
                                          ng-show="totextarea.tags"
                                          ng-maxlength="maxValueLength"
                                          ng-model="new.variables.tags"
                                ></textarea>
                                <div class="validation-error" ng-show="form.tags.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="form.tags.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>

                            <label class="flex-grow">
                                <div>Description</div>
                                <input style="width: 100%;" placeholder="Data description"
                                       ng-model="new.variables.comment"
                                       ng-maxlength="maxValueLength"
                                       name="description"
                                       not-cfe-variable
                                />
                                <div class="validation-error" ng-show="form.description.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="form.description.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                        </div>
                        <div class="flex flex--end flex--align_center margin-top">
                            <button type="button"  ng-click="cancelAdding('variables')"
                                    class="btn-transparent cancel margin-right-small">
                                Cancel
                            </button>
                            <button
                                type="button"
                                    ng-disabled="form.$invalid"
                                    ng-click="save('variables', new.variables.name, new.variables)"
                                    class="btn-primary btn btn-large">
                                Save
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <div class="card-footer" ng-class="{'disabled': editing.variables.index !== undefined}">
            <div class="flex flex-space-between">
                <div>
                    <button ng-if="new.variables === null && permissions.create" ng-click="addItemAction('variables')"
                            class="btn-transparent">
                        <span class="bi bi-plus-circle"></span> Add Variable
                    </button>
                </div>
                <div class="cmdb-pagination">
                    <button ng-disabled="pagination.variables.page < 2"
                            ng-click="pagination.variables.page = pagination.variables.page - 1"
                            class="btn-transparent prev"><
                    </button>
                    <input type="number" min="1" max="{{ pagination.variables.total }}" value="1"
                           ng-model="pagination.variables.page"/>
                    <span>&nbsp;/&nbsp;</span>
                    <span> {{ pagination.variables.max }}</span>
                    <button ng-disabled="pagination.variables.page == pagination.variables.max"
                            ng-click="pagination.variables.page = pagination.variables.page + 1"
                            class="btn-transparent next">>
                    </button>
                </div>
            </div>
        </div>
    </div>


    <div class="cmdb--classes card margin-top-large">
        <div class="card-header">Classes</div>
        <div class="card-body">
            <div class="items">
                <div class="item" ng-repeat="item in filtered.classes track by $index"
                     ng-class="{'item-last': $last, 'highlighted': highlight.name === item.name}">
                    <div ng-if="editing.classes.index !== $index"
                         ng-class="{'disabled': (editing.classes.index!== undefined && editing.classes.index !== $index) || new.classes !== null}">
                        <div class="flex margin-bottom-small flex-space-between">
                            <div class="item-name cmdb-text-container">
                                <div class="tooltip-box">
                                    <span class="cmdb-text">{{ item.name }}</span>
                                    <span class="tooltip-text">
                                        <div ng-repeat="(key,value) in tooltippedClassName(item.name) track by $index">{{ key }}: {{ value }}</div>
                                    </span>
                                </div>
                            </div>
                            <div class="item-actions relative">
                                <button class="btn-transparent" ng-if="permissions.update || permissions.delete" ng-click="addOpenedClass($event)">...</button>
                                <div class="item-actions-dropdown">
                                    <button ng-if="permissions.update" ng-click="editClass($index)" class="btn-transparent">
                                        <i class="icon-pencil edit"></i> Edit
                                    </button>
                                    <button ng-if="permissions.delete" ng-click="delete('classes', item.name, hostkey)" class="btn-transparent">
                                        <i class="icon-trash"></i> Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="flex">
                            <div class="item-tags flex flex-wrap">
                                <span ng-repeat="tag in item.tags track by $index" ng-bind-html="tag"></span>
                            </div>
                            <div class="tooltip-box">
                                <div class="item-description" ng-bind-html="item.comment"></div>
                                <span ng-class="{'hide': item.comment.length < 111 }"
                                      class="tooltip-text cmdb-text"
                                      ng-bind-html="item.comment">
                                </span>
                            </div>
                        </div>
                    </div>
                    <form name="editClassForm" ng-if="editing.classes.index === $index">
                        <div class="flex flex-space-between margin-bottom-small">
                            <label class="nameLabel">
                                <div>Name *</div>
                                <input
                                        required
                                        ng-maxlength="maxNameLength"
                                        name="name"
                                        ng-pattern="namePattern"
                                        ng-model="editing.classes.name"
                                        initvalue="{{filtered.classes[editing.classes.index].name}}"
                                        itemtype="classes"
                                        hostkey="{{hostkey}}"
                                        name-exists
                                />
                                <div class="validation-error" ng-show="editClassForm.name.$error.pattern">Alphanumeric
                                    and underscore are only allowed
                                </div>
                                <div class="validation-error" ng-show="editClassForm.name.$error.required">Please enter
                                    the name
                                </div>
                                <div class="validation-error" ng-show="editClassForm.name.$error.nameExists">Name
                                    already exists
                                </div>
                                <div class="validation-error" ng-show="editClassForm.name.$error.maxlength">
                                    Max length ({{maxNameLength}}) is exceeded
                                </div>
                            </label>
                        </div>
                        <div class="flex">
                            <label class="nameLabel">
                                <div>Tags</div>
                                <input ng-init="editing.classes.tags = editing.classes.tags || []"
                                       ng-focus="inputFocused($event, 'tags', editing.classes)"
                                       ng-hide="totextarea.tags"
                                       ng-value="editing.classes.tags.join(', ')"
                                       ng-model="editing.classes.tags"
                                       ng-maxlength="maxValueLength"
                                       not-cfe-variable
                                       name="tags" />
                                <textarea placeholder="Press enter to add new tags (optional)"
                                          style="width: 90%;" rows="3"
                                          ng-blur="textAreaBlur($event, 'tags', editing.classes)"
                                          ng-show="totextarea.tags"
                                          ng-maxlength="maxValueLength"
                                          ng-model="editing.classes.tags"></textarea>
                                <div class="validation-error" ng-show="editClassForm.tags.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="editClassForm.tags.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                            <label class="flex-grow">
                                <div>Description</div>
                                <input style="width: 100%;" ng-model="editing.classes.comment"
                                       ng-maxlength="maxValueLength" name="description" not-cfe-variable/>
                                <div class="validation-error" ng-show="editClassForm.description.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="editClassForm.description.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                        </div>
                        <div class="flex flex--end flex--align_center margin-top">
                            <button type="button" ng-click="cancelEditing()"
                                    class="btn-transparent cancel margin-right-small">
                                Cancel
                            </button>
                            <button type="button" ng-disabled="editClassForm.$invalid" ng-click="save('classes', filtered.classes[editing.classes.index].name, editing.classes, false, filtered.classes[editing.classes.index].name !== editing.classes.name)"
                                    class="btn-primary btn btn-large">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
                <div ng-if="new.classes !== null" class="item item-add">
                    <form name="addClassForm">
                        <div class="flex flex-space-between margin-bottom-small">
                            <label class="nameLabel">
                                <div>Name *</div>
                                <input
                                        name="name"
                                        required
                                        ng-pattern="namePattern"
                                        ng-maxlength="maxNameLength"
                                        ng-model="new.classes.name"
                                        hostkey="{{hostkey}}"
                                        itemtype="classes"
                                        name-exists
                                />
                                <div class="validation-error" ng-show="addClassForm.name.$error.pattern">Alphanumeric
                                    and underscore are only allowed
                                </div>
                                <div class="validation-error" ng-show="addClassForm.name.$error.required">Please enter
                                    the name
                                </div>
                                <div class="validation-error" ng-show="addClassForm.$error.nameExists">Name already
                                    exists
                                </div>
                                <div class="validation-error" ng-show="addClassForm.name.$error.maxlength">
                                    Max length ({{maxNameLength}}) is exceeded
                                </div>
                            </label>
                        </div>
                        <div class="flex">
                            <label class="nameLabel">
                                <div>Tags</div>
                                <input ng-focus="inputFocused($event, 'tags', new.classes)" ng-hide="totextarea.tags"
                                       ng-value="new.classes.tags.join(', ')"
                                       ng-model="new.classes.tags"
                                       ng-maxlength="maxValueLength"
                                       not-cfe-variable
                                       name="tags" />
                                <textarea placeholder="Press enter to add new tags (optional)"
                                          style="width: 90%;" rows="3"
                                          ng-blur="textAreaBlur($event, 'tags', new.classes)"
                                          ng-show="totextarea.tags"
                                          ng-maxlength="maxValueLength"
                                          ng-model="new.classes.tags"></textarea>
                                <div class="validation-error" ng-show="addClassForm.tags.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                                <div class="validation-error" ng-show="addClassForm.tags.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                            </label>
                            <label class="flex-grow">
                                <div>Description</div>
                                <input style="width: 100%;" ng-model="new.classes.comment" ng-maxlength="maxValueLength"
                                       name="description" not-cfe-variable/>
                                <div class="validation-error" ng-show="addClassForm.description.$error.maxlength">
                                    Max length ({{maxValueLength}}) is exceeded
                                </div>
                                <div class="validation-error" ng-show="addClassForm.description.$error.CFEVariableDetected">
                                    CFEngine variables are not allowed
                                </div>
                            </label>
                        </div>
                        <div class="flex flex--end flex--align_center margin-top">
                            <button type="button"  ng-click="cancelAdding('classes')"
                                    class="btn-transparent cancel margin-right-small">
                                Cancel
                            </button>
                            <button type="button"  ng-disabled="addClassForm.$invalid" ng-click="save('classes', new.classes.name, new.classes)"
                                    class="btn-primary btn btn-large">
                                Save
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <div class="card-footer" ng-class="{'disabled': editing.classes.index !== undefined}">
            <div class="flex flex-space-between">
                <div>
                    <button ng-if="new.classes === null && permissions.create" ng-click="addItemAction('classes')" class="btn-transparent">
                        <span class="bi bi-plus-circle"></span> Add Class
                    </button>
                </div>
                <div class="cmdb-pagination">
                    <button ng-disabled="pagination.classes.page < 2"
                            ng-click="pagination.classes.page = pagination.classes.page - 1"
                            class="btn-transparent prev"><
                    </button>
                    <input type="number" min="1" max="{{ pagination.classes.total }}" value="1"
                           ng-model="pagination.classes.page"/>
                    <span>&nbsp;/&nbsp;</span>
                    <span> {{ pagination.classes.max }}</span>
                    <button ng-disabled="pagination.classes.page == pagination.classes.max"
                            ng-click="pagination.classes.page = pagination.classes.page + 1"
                            class="btn-transparent next">>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div ng-if="(permissions | filterObject:'false' | objectLength) > 0" class="muted margin-top">
        Your role does not have
        <span ng-repeat="(permission, value) in permissions | filterObject:'false'"  ng-if="value==false">
            {{ permission }}
            <span ng-if="!$last">,</span>
        </span> permission<span ng-if="(permissions | filterObject:'false' | objectLength) > 1">s</span>.
    </div>
</div>
</div>

<script type="text/ng-template" id="deleteCMDB.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="close();"><i class="bi bi-x"></i></button>
        <h2>Delete data?</h2>
    </div>
    <div class="modal-body">
        Are you sure you want to delete <b>{{ name }}</b> ?
    </div>

    <div class="modal-footer ng-scope">
        <button class="btn btn-large" data-dismiss="modal" ng-click="close()">Cancel</button>
        <button class="btn btn-large btn-primary" data-dismiss="modal" ng-click="removeItem()">Remove</button>
    </div>
</script>

<script>
    // close actions dropdown on document click
    $(document).click(function () {
        $('.item-actions.opened').removeClass('opened');
    });

    // close actions dropdown on escape key press
    $(document).keyup(function (e) {
        if (e.key === "Escape") {
            $('.item-actions.opened').removeClass('opened');
        }
    });

    $(document).on('CMDB_PAGINATED', () => {
        setTimeout(() => {
            let tooltipBoxes = $('.tooltip-text');
            document.querySelectorAll('.tooltip-box').forEach(item => {
                item.onmousemove = function (e) {
                    let x = e.clientX, y = e.clientY;
                    tooltipBoxes.css('top', (y + 10) + 'px').css('left', (x + 10) + 'px');
                }
            });
        }, 1000);
    });

    $(document).on('CMDB_EDIT_OPENED', () => {
        setTimeout(() => {
            $('div[cmdb] input, div[cmdb] textarea').focus(function () {
                $(this).closest('label').addClass('active')
            });
            $('div[cmdb] input, div[cmdb] textarea').blur(function () {
                $(this).closest('label').removeClass('active')
            });

        }, 100);
    });
</script>
