'use strict';
/*
 * Service to controll pagination
 *
 */

reports.factory('paginationService', function($rootScope) {
    var self = this;

    var defaultRowsPerPage = RowsPerPage[2];


    self.paginator = {


        page : 1, // current page
        pages: 1, // how many pages we have after query

        rowsPerPageList: RowsPerPage, // dropdown  for select how many rows we have per page
        rowsPerPage    : defaultRowsPerPage, // current value from rows per page


        // result related variables
        resultCount    : 0, // how many rows in result
        //sortColumn     : '',
        //sortDescending : 0,
        skip           : 0, // used for limit

        resultPagesList: [], // show links list 1,2,3..


        setPages: function(resultCount){
            self.paginator.resultCount = resultCount;
            self.paginator.pages = Math.ceil(resultCount/self.paginator.rowsPerPage);
        },
        refreshPaginator: function(resultCount) {

            self.paginator.setPages(resultCount);

            var start = 0;
            var end   = 0;

            self.paginator.resultPagesList = [];

            if(self.paginator.pages > 5 )
            {

                if (self.paginator.page > 3 && self.paginator.page < (self.paginator.pages - 1))
                {
                    start = self.paginator.page - 2;
                    end   = self.paginator.page + 3;
                }
                else if(self.paginator.page === (self.paginator.pages - 1) || self.paginator.page === self.paginator.pages) {
                    start = self.paginator.pages - 4;
                    end   = self.paginator.pages + 1;
                }
                else {
                    start = 1;
                    end   = 6;
                }
            }
            else {
                start  = 1;
                end = self.paginator.pages+1;
            }

            for (start; start < end; start ++) {
                self.paginator.resultPagesList.push(start);
            }
        },
        paginationReset: function () {
            self.paginator.page  = 1;
            self.paginator.pages = 1;
            self.paginator.skip  = 0;
            self.paginator.resultCount = 0;
            self.paginator.resultPagesList = [];
            self.paginator.rowsPerPage = self.paginator._setDefaultRowsPerPage();
        },
        reloadView: function(page) {
            var newPage = page;

            if(self.paginator.page === page) {
                return;
            }

            if (page<1)
            {
                newPage = 1;
            }

            if (page>self.paginator.pages)
            {
                newPage = self.paginator.page;
            }

            if (self.paginator.page !== newPage)
            {
                self.paginator.page = newPage;

                if(self.paginator.page === 1)
                {
                    self.paginator.skip = 0;
                }
                else
                {
                    self.paginator.skip = (self.paginator.page-1) * self.paginator.rowsPerPage;
                }
            }
           if (self.paginator.resultCount) {
                $rootScope.$broadcast('paginatorChange');
            }
        },
        setRowsPerPage:  function(val){
            if(val !=='')
            {
                self.paginator.rowsPerPage = val;
                self.paginator.page = 1;
                self.paginator.setPages(self.paginator.resultCount);
                self.paginator.skip = 0;

                $rootScope.$broadcast('paginatorChange');
            }
        },
        _setDefaultRowsPerPage: function() {
            return defaultRowsPerPage;
        },

        getResultsOnPage: function() {

            if (self.paginator.page === self.paginator.pages) {
                return (self.paginator.resultCount % self.paginator.rowsPerPage) || self.paginator.rowsPerPage;
            } else {
                return Math.min(self.paginator.resultCount, self.paginator.rowsPerPage);
            }
        },
        getStartIndex: function() {
            return self.paginator.page * self.paginator.rowsPerPage - self.paginator.rowsPerPage + 1;
        },
        getEndIndex: function() {
            const end = self.paginator.page * self.paginator.rowsPerPage;
            return end > self.paginator.resultCount ? self.paginator.resultCount : end;
        }
    };

    return  self.paginator;
});