<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends cf_base_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library(array('form_validation'));
        $this->lang->load('cf_message');
        //list of errors wrapped in <p> class of errors
        $this->form_validation->set_error_delimiters('<span class="errorlist">', '</span>');
        //$this->load->database();
        $this->load->helper('url');
        $this->config->load('ion_auth', TRUE);
        $this->load->model('ProfileModel');


        $js = [
            ['node_modules/jquery/dist/jquery.min.js'],
            ['node_modules/jquery-form/dist/jquery.form.min.js'],
            ['node_modules/jquery-validation/dist/jquery.validate.min.js'],
            ['bootstrap/compiled/js/bootstrap.min.js'],
            ['showPassword.js'],
            ['node_modules/jstimezonedetect/dist/jstz.min.js'],
            ['node_modules/zxcvbn/dist/zxcvbn.js'],
        ];

        $this->carabiner->js(dev_file: $js, prod_file: $js, combine: true, minify: true, group: 'login');
    }

    //log the user out
    function logout()
    {
        $this->session->unset_userdata("defaultadmin");
        $this->data['title'] = "Logout";

        try
        {

            $logout = $this->ion_auth->logout();
        }
        catch(Exception $e)
        {
            log_message(log_level_for_exception($e),'Error login out user. '.$e->getMessage());
        }

        if(isset($_COOKIE['profileToLoad'])){
            setcookie('profileToLoad', '', time() - 3600, '/');
        }

        //redirect them back to the page they came from
        redirect('login/index', 'refresh');
    }

    //log the user in
    function index()
    {
        $this->data['title'] = "Login";
        $identifier = $this->config->item('identity', 'ion_auth');
        //validate form input
        if ($identifier == "username")
            $this->form_validation->set_rules('username', 'Username', 'required');
        else
            $this->form_validation->set_rules('email', 'Email Address', 'required|valid_email');

        $this->form_validation->set_rules('password', 'Password', 'required');

        if ($this->form_validation->run() == false) {
            //the user is not logging in so display the login page
            //set the flash data error message if there is one
            $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

            $this->data['lbl_identifier'] = "Username";
            $this->data['identifier'] = array('name' => 'username',
                'id' => 'username',
                'type' => 'text',
                'value' => $this->form_validation->set_value('username'),
            );

            $this->data['password'] = array('name' => 'password',
                'id' => 'password',
                'type' => 'password',
            );

            $this->data['timezone'] = array('name' => 'timezone',
                'id' => 'timezone',
                'type' => 'hidden',
            );
            $this->load->model('customization_model');
            $this->data = array_merge($this->data, $this->customization_model->getSettings());

            $this->load->view('auth/login', $this->data);
            return;
        }

            $remember = (bool) $this->input->post('remember');
            // add a session variable for the timezone information of the user for date conversion
            $this->session->set_userdata('user_timezone', $this->input->post('timezone'));

            if ($this->ion_auth->login(trim($this->input->post($identifier)), $this->input->post('password'), $remember))
            {
                $this->session->set_userdata('securitySettings', json_encode($this->setting_lib->getSecuritySettings()));

                // If login was successful, but credentials are admin/admin:
                if ($this->input->post($identifier)=="admin" && $this->input->post('password')=="admin" && $this->session->userdata('firstLogin')) {
                    $this->session->set_userdata(['defaultadmin' => true]);
                    redirect('login/change_default', 'refresh');
                } elseif ($this->ProfileModel->getAdditionalData($this->input->post($identifier), ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY) === 'true') {
                    redirect('login/change_default', 'refresh');
                } else {
                    $this->session->set_flashdata('message', array('type'=>'alert-error','content'=>$this->ion_auth->errors()));
                    if(!empty(get_cookie('url_to_redirect_after_login')))
                    {
                        $url = get_cookie('url_to_redirect_after_login');
                        delete_cookie('url_to_redirect_after_login');
                        redirect($url, 'refresh');
                    }
                    redirect('welcome/index', 'refresh');
                }
            }
            else
            { //if the login was un-successful
                //redirect them back to the login page
                $this->session->set_flashdata('message', array('type'=>'alert-error','content'=>$this->ion_auth->errors()));
                redirect('login/index', 'refresh'); //use redirects instead of loading views for compatibility with MY_Controller libraries
            }

    }

     function forgot_password()
    {
        //$this->form_validation->set_rules('email', 'Email Address', 'required|valid_email');
        $this->data['title'] = "Forgot Password";
        $this->form_validation->set_rules('username', 'User Name', 'required');

        if ($this->form_validation->run() == false)
        {

            //set any errors and display the form
            if(validation_errors()){
                $this->data['message'] = validation_errors() ;
            }
            $this->data['username']= $this->form_validation->set_value('username');
            $this->load->view('auth/forgot_password', $this->data);
        }
        else
        {
            //run the forgotten password method to email an activation code to the user
            $forgotten = $this->ion_auth->forgotten_password($this->input->post('username'));

            if ($forgotten)
            { //if there were no errors
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                redirect("login/index", 'refresh'); //we should display a confirmation page here instead of the login page
            }
            else
            {
                $this->data['message']=array('type'=>'alert-error','content'=> $this->ion_auth->errors());
                $this->data['username']= $this->form_validation->set_value('username');
                $this->load->view('auth/forgot_password', $this->data);
            }
        }
    }

    function change_default()
    {
        $js = [['changePassword.js']];
        $this->carabiner->js(dev_file: $js, prod_file: $js, combine: true, minify: true, group: 'login');
        if ($this->session->userdata('securitySettings')) {
            $securitySettings = json_decode($this->session->userdata('securitySettings'), $associative = true);
        } else {
            /**
             * fallback values that UI will use in case of missing security settings pre-set on the login step
             * even if default values will be different from what is saved, backend will perform validation anyway.
             */
            $securitySettings = [
                'minPasswordLength' => 8,
                'passwordComplexity' => 3
            ];
        }
        $this->data = [...$securitySettings];

        $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY] = $this->ProfileModel->getAdditionalData($this->session->userdata('username'), ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY) === 'true';
        if (
            $this->session->userdata("defaultadmin") ||
            $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY]
        )
        {
            $this->data['title'] = "Change default password";
            $this->data['explanation'] = $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY] ? $this->lang->line('change_reset_password') : $this->lang->line('default_admin_password_change');
            $this->load->view('auth/change_default', $this->data);
        }
        else
        {
            redirect("welcome/index", 'refresh');
        }


    }

}