<?php

/**
 * Class Ldap_api
 */
class Ldap_api
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
    }

    /**
     * @param $pest
     * @return bool
     */
    public function testLdapUrl(HttpClientInterface $pest)
    {
        try {
            $settingsResponse = $pest->get(
                'settings',
                ['Authorization' => $this->ci->config->item('LDAP_API_SERVER_SECRET')]
            );

            return boolval(strstr($settingsResponse,'login_attribute'));
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage());
        }

        return false;
    }

    /**
     * @param HttpClientInterface $pestClient
     * @return array|mixed
     */
    public function getSettings(HttpClientInterface $pestClient)
    {
        try {
            $settingsResponse = $pestClient->get(
                '/settings',
                ['Authorization' => $this->ci->config->item('LDAP_API_SERVER_SECRET')]
            );
            $settings = json_decode($settingsResponse, true);
            $data = isset($settings['data']) ? $settings['data'] : [];
            return $this->prepareDataForGet($data);
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage());
        }

        return [];
    }


    public function getUsers(HttpClientInterface $pestClient, $perPage, $page, $searchStr = '')
    {
        try {
            $settingsResponse = $pestClient->get(
                '/users?perPage=' . $perPage . '&page=' . $page . '&search=' . $searchStr,
                ['Authorization' => $this->ci->config->item('LDAP_API_SERVER_SECRET')]
            );
           return $settingsResponse;
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage());
        }

        return [];
    }

    /**
     * @param HttpClientInterface $pestClient
     * @param array $settings
     * @return array
     */
    public function saveSettings(HttpClientInterface $pestClient, array $settings)
    {
        try {
            $settingsResponse = $pestClient->patch(
                '/settings',
                $this->prepareDataForUpdate($settings),
                [
                    'Authorization' => $this->ci->config->item('LDAP_API_SERVER_SECRET'),
                    'Content-Type' => 'application/json'
                ]
            );
            $settings = json_decode($settingsResponse, true);
            return ['success' => (isset($settings['success']) && $settings['success'] == true), 'message' => ''];
        } catch (Exception $e) {
            $error = json_decode($e->getMessage()) != null ? json_decode($e->getMessage())->message : '';
            log_message('error', $e->getMessage());
            return ['success' => false, 'message' => $error];
        }

        return ['success' => false, 'message' => ''];
    }

    /**
     * @param $data
     * @return mixed
     */
    private function prepareDataForGet($data)
    {
        $data['encryption'] = 'plain';

        if (isset($data['use_ssl']) && $data['use_ssl'] === true) {
            $data['encryption'] = 'ssl';
        }

        if (isset($data['use_tls']) && $data['use_tls'] === true) {
            $data['encryption'] = 'tls';
        }

        return $data;
    }

    /**
     * @param $data
     * @return mixed
     */
    private function prepareDataForUpdate($data)
    {
        if (!isset($data['encryption'])) {
            return $data;
        }

        $data['use_ssl'] = 'false';
        $data['use_tls'] = 'false';

        if ($data['encryption'] === 'ssl') {
            $data['use_ssl'] = 'true';
        }

        if ($data['encryption'] === 'tls') {
            $data['use_tls'] = 'true';
        }

        return $data;
    }
}