<?php

//******************************* M O D A L *******************************************************
$this->load->view('/partials/_saveSearchModal');
//******************************* M O D A L *******************************************************
?>
<main class="compliance">
    <div>
        <div class="pageTitle">
            <h1>
                <span>{{reportLabel || 'Results'}}</span>
            </h1>
        </div>
        <div class="flex flex-space-between margin-top">
            <div class="relative">
                <div class="accordion-group">
                    <btn ng-class="{'pressed':showFilter}"
                         ng-click="showFilter=!showFilter"
                         class="btn btn-dark-blue"
                         data-parent="#filterTree"
                         data-toggle="collapse">
                        <span id="filterToggle">
                            <i class="bi bi-filter"></i>
                            Filter <span ng-show="originalFilters.length"
                                         class="help-block inline"
                                         style="font-size:14px; font-style:normal">({{originalFilters.length}})</span>
                        </span>
                    </btn>
                </div>
                <div id="filterTree" ng-init="showFilter=false" ng-class="{'open':showFilter}">
                    <div ng-show="showFilter" class="margin-left-small margin-bottom-small">
                        <?php $this->load->view('/partials/_environmentFilter'); ?>
                    </div>
                </div>
            </div>
            <div class="flex">
                <div>
                    <a class="pull-left btn" ng-show="reportId && readonly != 1 && can_edit == 1"
                       ng-href="compliance/edit/{{reportId}}"
                       ng-click="$event.stopPropagation()">Edit</a>
                    <a class="pull-left btn" ng-hide="reportId" ng-href="compliance/add_report"
                       ng-click="$event.stopPropagation()">Edit</a>
                    <input type="hidden" value="{{csvArray}}" id="csvArray">
                    <input type="hidden" value="compliance" id="reportCategory">
                </div>
                <div>
                    <?php $this->load->view('/partials/_download_report_btn'); ?>
                </div>
            </div>
        </div>

        <div style="margin-top: 40px;">
            <h2>Overview</h2>
            <div class="flex">
                <div high-charts
                     ng-if="overallConfig"
                     id="overall"
                     config="overallConfig"
                     class="inline-block"
                     style="width: 220px; height: 250px; margin-right: 200px">
                </div>
                <div
                        high-charts
                        id="category_failures"
                        config="categoriesConfig"
                        class="inline-block"
                        style="width: 500px; height: 250px">
                </div>
            </div>
        </div>
        <div class="margin-top">
            <h2>Checklist</h2>
            <div ng-if="!isEmptyObj(savedConditions)" class="check-list-item"
                 ng-repeat="(category, conditions) in savedConditions">
                <div class="check-list-item-category">{{category}}</div>
                <div>
                    <table class="table fixed margin-top table-horizontal">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Severity level</th>
                            <th>Passing</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr class="rule-row" ng-repeat="(rowid, row) in conditions | orderBy: 'name'">
                            <td>
                                {{row.name}}
                                <div rule-details rule="row" class="tooltiptext unstyled break-all"></div>
                            </td>
                            <td>{{row.severity}}</td>
                            <td>{{row.pass}} / {{row.total}}
                                (<span class="score">{{row.score}}%</span>)
                                <a href="<?= site_url("reports/open_rule_report/all/") ?>{{row.id}}/{{ reportid }}"
                                   target="_blank"><i class="bi bi-box-arrow-up-right open-report"></i></a>
                                <i ng-show="row.pass == undefined" class="icon-spinner icon-spin"></i>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>
