/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global BaseController, angular*/

'use strict';


const includeExcludeByHostkeyDirective = BaseController.extend({

    init: function ($scope, $attrs, $modal, IEPaginationService, naviTreeService) {
        this.$modal = $modal;
        this.naviTreeService = naviTreeService;
        this._paginationService = IEPaginationService;

        this._super($scope);
    },

    defineScope: function () {
        this.$scope.showHost = this.showHost.bind(this);

        this.$scope.getHostsCountDescription = this.getHostsCountDescription.bind(this);
        this.$scope.hostsList = this.hostsList.bind(this);
        this.$scope.intersectionsInclExcl = this.intersectionsInclExcl.bind(this);
        this.$scope.isEmptyObject = this.isEmptyObject;
    },

    showHost: function (include) {
        let self = this;
        self.$scope.include = include;
        this.hostListModalInstance = this.$modal.open({
            templateUrl: 'hostSelectionByNameModal.html',
            backdrop: 'static',
            keyboard: true,
            windowClass: 'include',
            controller: function ($scope, $modalInstance, $filter, $parent, IEPaginationService, naviTreeService) {
                $scope.modalData = {
                    include: $parent.$scope.include,
                    searchString: '',
                    intersectionWarningMessage: 'This host is both included and excluded. Exclusion will take precedence.'
                };

                const defaultSearchResultCount = 8;

                $scope.includedHosts = angular.copy($parent.$scope.includedHosts);
                $scope.excludedHosts = angular.copy($parent.$scope.excludedHosts);

                $scope.getHostsCountDescription = $parent.getHostsCountDescription.bind(this);
                $scope.isEmptyObject = $parent.isEmptyObject;

                $scope.paginator = IEPaginationService;
                $scope.paginator.rowsPerPage = defaultSearchResultCount;

                const getNodeHostFailure = function (error) {
                    $scope.hostListError = error.data;
                    $scope.totalHostList = [];
                    $scope.showHosts = true;
                };

                const getNodeHostSuccess = function (result) {
                    $scope.totalHostList = result.data.data;
                    $scope.originalHostList = angular.copy($scope.totalHostList);
                    $scope.showHosts = true;
                    $scope.paginator.refreshPaginator(result.data.meta.rowCount);
                    $scope.totalHosts = result.data.meta.rowCount; // needed by paginator.page watch below
                };

                $scope.$watch('paginator.page', function (newPage, oldPage) {
                    if (newPage !== oldPage) {
                        naviTreeService.searchHosts($scope.modalData.searchString, defaultSearchResultCount, defaultSearchResultCount * ($scope.paginator.page - 1), true).then(getNodeHostSuccess, getNodeHostFailure);
                        $scope.selectedHosts = {};
                        $scope.paginator.refreshPaginator($scope.totalHosts);
                    }
                })

                $scope.save = function () {
                    if ($parent.$scope.include) {
                        $parent.$scope.includedHosts = angular.copy($scope.includedHosts);
                    } else {
                        $parent.$scope.excludedHosts = angular.copy($scope.excludedHosts);
                    }
                    $scope.close();
                }

                $scope.$watch('modalData.searchString', function (query) {
                    naviTreeService.searchHosts(query, defaultSearchResultCount, 0, true).then(getNodeHostSuccess, getNodeHostFailure);
                });

                $scope.addExcludedHost = function (host) {
                    $scope.excludedHosts[host.hostkey] = host.hostname;
                };

                $scope.addIncludedHost = function (host) {
                    $scope.includedHosts[host.hostkey] = host.hostname;
                };

                $scope.close = function () {
                    $modalInstance.close('cancel');
                };

                $scope.clearAll = function () {
                    if ($parent.$scope.include) {
                        $scope.includedHosts = {};
                    } else {
                        $scope.excludedHosts = {};
                    }
                }

                $scope.deleteExcludedHosts = function (hostkey) {
                    if ($scope.excludedHosts.hasOwnProperty(hostkey)) {
                        delete $scope.excludedHosts[hostkey];
                    }
                };

                $scope.deleteIncludedHosts = function (hostkey) {
                    if ($scope.includedHosts.hasOwnProperty(hostkey)) {
                        delete $scope.includedHosts[hostkey];
                    }
                };

            },
            resolve: {
                naviTreeService: function () {
                    return self.naviTreeService;
                },
                $parent: function () {
                    return self;
                },
                paginationService: function () {
                    return self._paginationService;
                }
            }
        });
    },

    getHostsCountDescription: function (hosts, addition = '') {
        const hostsCount = Object.keys(hosts).length;
        return `${hostsCount.toString()} ${addition} ${hostsCount > 1 ? 'hosts' : 'host'}`;
    },

    isEmptyObject: function (data) {
        return Object.keys(data).length == 0;
    },

    intersectionsInclExcl: function ()  {
        return  (Object.keys(this.$scope.includedHosts).filter(item => Object.keys(this.$scope.excludedHosts).includes(item)).length > 0);
    },

    // if the joined list of hosts is greater than 75 characters truncate and add ellipsis
    hostsList: function (hosts) {
        const list = Object.values(hosts).join(', ');
        return list.length > 75 ? list.substring(0,75)+'...' :
               list;
    },
});
