angular.module('healthIssueDirective', [])
    .directive('healthIssue', [ function () {
    return {
        restrict: 'A',
        scope: {
            category: '='
        },
        template: `<a target="_blank"
                      title="{{description}}"
                      href="/reports/health-diagnostic/{{category}}"
                      class="red"
                      style="text-decoration: none">
                      <span class="red icon-warning-sign"></span>
                  </a>`,

        link: function($scope, $elm, $attrs) {
            if ($attrs.category != undefined) {
                const issuesMap = {
                    notRecentlyCollected: "Host not recently reported",
                    hostsUsingSameIdentity: "Hosts likely using the same identity",
                    agentNotRunRecently: "Agent not run recently",
                    lastAgentRunUnsuccessful: "Last agent run unsuccessful"
                }

                const issue = issuesMap[$attrs.category] != undefined ? ': ' + issuesMap[$attrs.category] : '';
                // transform camelCase to dash-delimited
                $scope.category =  $attrs.category.replace(/([A-Z])/g, "-$1").toLowerCase();
                $scope.description = 'Health issue detected' + issue + '. ' +
                                     'Click to see a corresponding report';
            }
        }
    };
}]);
