<div>
    <form class="include-exclude-form">
        <div>
            <a ng-if="!isEmptyObject(includedHosts)" href="#" class="btn btn-link btn-large" role="button" ng-click="showHost(true)">
                {{ getHostsCountDescription(includedHosts, 'additional') }}
                <i    rel="tooltip"
                      ng-if="intersectionsInclExcl()"
                      data-original-title="Some hosts are both included and excluded. Exclusion will take precedence."
                      data-placement="right"
                      class="bi bi-exclamation-triangle-fill">
                </i>
                <br />
                ({{ hostsList(includedHosts) }})
            </a>
            <a ng-if="isEmptyObject(includedHosts)"
               href="#" class="btn btn-link btn-large" role="button" ng-click="showHost(true)">
                Include additional hosts
            </a>
        </div>
        <div>
            <a  ng-if="!isEmptyObject(excludedHosts)"
                href="#" class="btn btn-link btn-large" role="button" ng-click="showHost(false)">
                {{ getHostsCountDescription(excludedHosts, 'excluded') }}
                <br />
                ({{ hostsList(excludedHosts) }})
            </a>
            <a ng-if="isEmptyObject(excludedHosts)" href="#" class="btn btn-link btn-large" role="button" ng-click="showHost(false)">
               Exclude hosts
            </a>
        </div>
    </form>
</div>

<script type="text/ng-template" id="hostSelectionByNameModal.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="hostSearch =''; close()">
            <i class="bi bi-x"></i>
        </button>
        <h2 ng-if="modalData.include">Include additional hosts</h2>
        <h2 ng-if="!modalData.include">Exclude hosts</h2>
    </div>
    <div class="row modal-body no-padding include-additional-modal" style="min-height: 440px;">
        <div class="subtitle" ng-if="modalData.include">
            Including hosts will cause them to be added to the filter results, even if they don't match the rules of the
            filter.
        </div>
        <div class="subtitle" ng-if="!modalData.include">
            Excluding hosts will remove them from the filter results.
        </div>
        <div class="main">
            <div class="inclExcl">
                <div>

                <span class="searchBlock">
                        <input ng-model="modalData.searchString" name="modalData.searchString"
                               type="text" placeholder="Search hostname, IP">
                        <span ng-click="modalData.searchString = ''" ng-show="modalData.searchString != ''"
                              class="clearSearch">x</span>
                </span>

                    <div ng-show="showHosts && totalHostList.length == 0">
                        <p>Sorry, no hosts matched your criteria</p>
                    </div>

                    <div class="host-list" ng-show="totalHostList.length > 0">
                        <ul ng-show="modalData.include" class="unstyled">
                            <li ng-repeat="host in totalHostList" ng-class="{'selected': includedHosts[host.hostkey].length}">
                                <div class="checkbox">
                                    <div title="{{host.hostname}}" class="host-list_name">{{host.hostname}}</div>
                                    <div ng-if="!includedHosts[host.hostkey]" style="float: right;">
                                        <span class="btn-select dnc" ng-click="addIncludedHost(host)">Include</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                        <ul ng-show="!modalData.include" class="unstyled">
                            <li ng-repeat="host in totalHostList" ng-class="{'selected': excludedHosts[host.hostkey].length}">
                                <div class="checkbox">
                                    <div title="{{host.hostname}}" class="host-list_name">{{host.hostname}}</div>
                                    <div ng-if="!excludedHosts[host.hostkey]" style="float: right;">
                                        <span class="btn-select dnc" ng-click="addExcludedHost(host)">Exclude</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <!--- PAGINATION  START -->
                    <div class="float-left paginator_SE">
                        <div class="pull-right pagination"
                             ng-show="paginator.resultCount > paginator.defaultRowsPerPage">
                            <ul class="pull-left">
                                <li ng-if="paginator.page != 1 && paginator.pages > 5">
                                    <a title="Go to First Page" ng-click="paginator.reloadView(1)"
                                       href="javascript:void(0)">First</a>
                                </li>
                                <li ng-if="paginator.page != 1">
                                    <a title="Go to Previous Page"
                                       ng-click="paginator.reloadView(paginator.page -1 || 1)"
                                       href="javascript:void(0)">&laquo;</a>
                                </li>


                                <li ng-repeat="item in paginator.resultPagesList"
                                    ng-class="{active: item == paginator.page}">
                                    <span ng-if="item == paginator.page">{{item}}</span>
                                    <a ng-if="item != paginator.page" title="Go to Page {{item}}"
                                       ng-click="paginator.reloadView(item)" href="javascript:void(0)">{{item}}</a>
                                </li>


                                <li ng-if="paginator.page != paginator.pages ">
                                    <a title="Go to Next Page"
                                       ng-click="paginator.reloadView(paginator.page+1 || paginator.pages)"
                                       href="javascript:void(0)">&raquo;</a>
                                </li>
                                <li ng-if="paginator.page != paginator.pages && paginator.pages > 5">
                                    <a title="Go to Last Page" ng-click="paginator.reloadView(paginator.pages)"
                                       href="javascript:void(0)">Last</a>
                                </li>
                            </ul>

                        </div>
                    </div>
                    <!--- PAGINATION END -->
                </div>
            </div>
            <div>
                <div ng-show="!modalData.include && !isEmptyObject(excludedHosts)">
                    <span class="clear-all">{{getHostsCountDescription(excludedHosts)}} excluded</span>
                    <button class="btn btn-link clear-all" ng-click="clearAll()"><i class="bi bi-trash"></i> Clear all
                    </button>
                    <div class="host-list-include">
                        <ul class="unstyled">
                            <li ng-repeat="(key, host) in excludedHosts">
                                <i  rel="tooltip"
                                    data-original-title="{{ modalData.intersectionWarningMessage }}"
                                    data-placement="left"
                                    ng-if="includedHosts[key]" class="bi bi-exclamation-triangle-fill">
                                </i>
                                <span>{{host}}</span>
                                <a type="button" ng-click="deleteExcludedHosts(key);"><i class="bi bi-x-lg dnc"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div ng-show="modalData.include && !isEmptyObject(includedHosts)">
                    <span class="clear-all">{{getHostsCountDescription(includedHosts)}} included</span>
                    <button class="btn btn-link clear-all" ng-click="clearAll()"><i class="bi bi-trash"></i> Clear all
                    </button>
                    <div class="host-list-include">
                        <ul class="unstyled">
                            <li ng-repeat="(key, host) in includedHosts">
                                <i  rel="tooltip"
                                    data-original-title="{{ modalData.intersectionWarningMessage }}"
                                    data-placement="left"
                                    ng-if="excludedHosts[key]"
                                    class="bi bi-exclamation-triangle-fill">
                                </i>
                                <span>{{host}}</span>
                                <a type="button" ng-click="deleteIncludedHosts(key);"><i class="bi bi-x-lg dnc"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <i class="help-text"
                   ng-if="(modalData.include && !isEmptyObject(includedHosts)) ||  (!modalData.include && !isEmptyObject(excludedHosts))"
                >
                    Hosts will remain in this list even if their hostname or IP address changes. The list is based on
                    CFEngine ID.
                </i>
            </div>
        </div>
    </div>

    <div class="modal-footer">
        <button class="btn btn-large btn-primary" ng-click="save()">Save</button>
    </div>
</script>
