<?php

abstract class HttpClientBase
{

    /**
     * @var string Base Url
     */
    protected $baseURL;

    /**
     * HttpClientBase constructor.
     * @param $baseURL
     */
    public function __construct($baseURL)
    {
        $this->baseURL = $baseURL;
    }

    /**
     * @return mixed
     */
    public function getBaseUrl()
    {
        return $this->baseURL;
    }


    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    public abstract function post($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    public abstract function get($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    public abstract function put($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    public abstract function delete($url, $data, $headers = []);

}