<?php

class SettingsHelper
{
    const PASSWORD_COMPLEXITY = 'passwordComplexity';
    const MIN_PASSWORD_LENGTH = 'minPasswordLength';
    const PASSWORD_EXPIRATION_AFTER_RESET_HOURS = 'passwordExpirationAfterResetHours';
    
    const INTEGERS = [
        self::PASSWORD_COMPLEXITY,
        self::MIN_PASSWORD_LENGTH,
        self::PASSWORD_EXPIRATION_AFTER_RESET_HOURS
    ]; 
    
    const DEFAULTS = [
        self::PASSWORD_COMPLEXITY => 3,
        self::MIN_PASSWORD_LENGTH => 8,
        self::PASSWORD_EXPIRATION_AFTER_RESET_HOURS => 48
    ];

    /** @var array */
    protected static $allowedSettings = [
        'rbacEnabled',
        'ldapEnabled',
        'hostIdentifier',
        'blueHostHorizon',
        'hostsCollisionsThreshold',
        'passwordComplexity',
        'minPasswordLength',
        'passwordExpirationAfterResetHours',
        'logLevel',
        'ldap_enable_role_syncing',
        'ldap_roles_list_to_sync',
        'ldap_perform_sync_on_login',
        'ldap_remove_role_on_syncing'
    ];

    /**
     * Remove LDAP Password from settings
     *
     * @param $settings
     * @return string
     */
    public static function removeLdapPassword($settings)
    {
        if (is_string($settings)) {
            $settings = json_decode($settings);
            if (isset($settings->data) && isset($settings->data[0]) && isset($settings->data[0]->ldapPassword)) {
                unset($settings->data[0]->ldapPassword);
            }
        }
        return json_encode($settings, JSON_PRETTY_PRINT);
    }

    /**
     * Remove not allowed settings
     *
     * @param $data
     */
    public static function removeUnAllowedSettings( &$data ) {
        foreach ( $data as $key => $value ) {
            if ( ! in_array( $key, self::$allowedSettings ) ) {
                unset( $data[ $key ] );
            }
        }
    }
}