<?php


class CfDeletedHost
{
    /**
     * @var PDO
     */
    private $pdo;


    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function getHosts($limit = null, $offset = 0) : array
    {
        $sth = $this->pdo->prepare('SELECT * FROM __hosts WHERE deleted IS NOT NULL OFFSET :offset LIMIT :limit');
        $sth->execute(array(':offset' => $offset, ':limit' => $limit));
        $hosts = $sth->fetchAll(PDO::FETCH_ASSOC);

        return [
            'data' => $hosts,
            'meta' => [
                'total' => $this->getDeletedHostCount(),
                'page' => $offset + 1,
                'count' => sizeof($hosts),
                'timestamp' => time(),
            ]
        ];
    }

    private function getDeletedHostCount() : int
    {
        return intval(
            (
                $this->pdo
                ->query('SELECT COUNT(*) as count FROM __hosts WHERE deleted IS NOT NULL')
                ->fetch(PDO::FETCH_ASSOC)
            )['count']
        );
    }

}
