<?php

namespace FR\V1_0\ConfigFile;

use FR\Interfaces\ConfigFileEntityInterface;
use FR\Interfaces\RemoteHubsCollectionInterface;

class ConfigFile implements ConfigFileEntityInterface
{
    private $hostname;
    private $role;
    private $remote_hubs;
    private $target_state;

    /**
     * @return mixed
     */
    public function getHostname()
    {
        return $this->hostname;
    }

    /**
     * @param mixed $hostname
     */
    public function setHostname($hostname)
    {
        $this->hostname = $hostname;
    }

    /**
     * @return mixed
     */
    public function getRole() : string
    {
        return $this->role;
    }

    /**
     * @param mixed $role
     */
    public function setRole($role)
    {
        $this->role = $role;
    }

    /**
     * @return mixed
     */
    public function getTargetState()
    {
        return $this->target_state;
    }

    /**
     * @param mixed $target_state
     */
    public function setTargetState($target_state)
    {
        $this->target_state = $target_state;
    }

    /**
     * @return mixed
     */
    public function getRemoteHubs() : RemoteHubsCollectionInterface
    {
        return $this->remote_hubs;
    }

    /**
     * @param mixed $remote_hubs
     */
    public function setRemoteHubs(RemoteHubsCollectionInterface $remote_hubs)
    {
        $this->remote_hubs = $remote_hubs;
    }

    public function jsonSerialize()
    {
        return $this->toArray();
    }

    public function toArray()
    {
        return [
            'hostname' => $this->getHostname(),
            'role' => $this->getRole(),
            'target_state' => $this->getTargetState(),
            'remote_hubs' => $this->getRemoteHubs()->toArray()
        ];
    }
}
