<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Carabiner 1.45 configuration file.
 * CodeIgniter-library for Asset Management
 */
/*
  |--------------------------------------------------------------------------
  | Script Directory
  |--------------------------------------------------------------------------
  |
  | Path to the script directory.  Relative to the CI front controller.
  |
 */

$config['script_dir'] = 'public/scripts/';
$config['script_url'] = 'scripts/';


/*
  |--------------------------------------------------------------------------
  | Style Directory
  |--------------------------------------------------------------------------
  |
  | Path to the style directory.  Relative to the CI front controller
  |
 */
if (is_constellation())
{
    $config['style_dir'] = 'public/themes/constellation/css/';
}
else
{
    $config['style_dir'] = 'public/themes/default/css/';
}

$config['style_url'] = 'themes/default/css/';

/*
  |--------------------------------------------------------------------------
  | Cache Directory
  |--------------------------------------------------------------------------
  |
  | Path to the cache directory. Must be writable. Relative to the CI
  | front controller.
  |
 */

$config['cache_dir'] = 'public/tmp/';
$config['cache_url_dir'] = 'tmp/';
$config['cache_permissions'] = 0440;




/*
 * The following config values are not required.  See Libraries/Carabiner.php
 * for more information.
 */



/*
  |--------------------------------------------------------------------------
  | Base URI
  |--------------------------------------------------------------------------
  |
  |  Base uri of the site, like http://www.example.com/ Defaults to the CI
  |  config value for base_url.
  |
 */

//$config['base_uri'] = 'http://www.example.com/';


/*
  |--------------------------------------------------------------------------
  | Development Flag
  |--------------------------------------------------------------------------
  |
  |  Flags whether your in a development environment or not. Defaults to FALSE.
  |
 */

$config['dev'] = (ENVIRONMENT == 'development') ? true : false; // set in index.php


/*
  |--------------------------------------------------------------------------
  | Combine
  |--------------------------------------------------------------------------
  |
  | Flags whether files should be combined. Defaults to TRUE.
  |
 */

$config['combine'] = TRUE;


/*
  |--------------------------------------------------------------------------
  | Minify Javascript
  |--------------------------------------------------------------------------
  |
  | Global flag for whether JS should be minified. Defaults to TRUE.
  |
 */

$config['minify_js'] = TRUE;


/*
  |--------------------------------------------------------------------------
  | Minify CSS
  |--------------------------------------------------------------------------
  |
  | Global flag for whether CSS should be minified. Defaults to TRUE.
  |
 */

$config['minify_css'] = TRUE;

/*
  |--------------------------------------------------------------------------
  | Force cURL
  |--------------------------------------------------------------------------
  |
  | Global flag for whether to force the use of cURL instead of file_get_contents()
  | Defaults to FALSE.
  |
 */

$config['force_curl'] = FALSE;


/*
  |--------------------------------------------------------------------------
  | Predifined Asset Groups
  |--------------------------------------------------------------------------
  |
  | Any groups defined here will automatically be included.  Of course, they
  | won't be displayed unless you explicity display them ( like this: $this->carabiner->display('jquery') )
  | See docs for more.
  |
  | Currently created groups:
  |	> jQuery (latest in 1.xx version)
  |	> jQuery UI (latest in 1.xx version)
  |	> Ext Core (latest in 3.xx version)
  |	> Chrome Frame (latest in 1.xx version)
  |	> Prototype (latest in 1.x.x.x version)
  |	> script.aculo.us (latest in 1.x.x version)
  |	> Mootools (1.xx version)
  |	> Dojo (latest in 1.xx version)
  |	> SWFObject (latest in 2.xx version)
  |	> YUI (latest core JS/CSS in 2.x.x version)
  |
 */

// CFEngine base
$config['groups']['CFEngine'] = array(
    'css' => array(
        array('../../../scripts/node_modules/jquery-ui-dist/jquery-ui.min.css', 'screen'),
        array('../bootstrap/compiled/css/cfengine.less.css', 'screen'),
        array('finders.css', 'screen'),
        // add cfengine MP custom styles
        array('bootstrap-wizard.css', 'screen'),
        array('../../../scripts/node_modules/chosen-js/chosen.min.css', 'screen'),
        array('../../../scripts/node_modules/simple-notify/dist/simple-notify.css'),
    ),
    'js' => array(
        array('constants.js', 'constants.js', TRUE, FALSE),
        array('node_modules/jquery/dist/jquery.min.js', 'node_modules/jquery/dist/jquery.min.js', TRUE, FALSE),
        array('node_modules/jquery-ui-dist/jquery-ui.min.js', 'node_modules/jquery-ui-dist/jquery-ui.min.js', TRUE, FALSE),
        array('node_modules/jquery.cookie/jquery.cookie.js', 'node_modules/jquery.cookie/jquery.cookie.js', TRUE, FALSE),
        array('libs/dateformat.js', 'libs/dateformat.js', TRUE, FALSE),
        array('rbac.js', 'rbac.js', TRUE, FALSE),
        array('common.js', 'common.js', TRUE, FALSE),
        array('node_modules/jstimezonedetect/dist/jstz.min.js', 'node_modules/jstimezonedetect/dist/jstz.min.js', TRUE, FALSE),
        array('../themes/default/bootstrap/cfengine/js/cfe-form-elements.js', '../themes/default/bootstrap/cfengine/js/cfe-form-elements.js', TRUE, FALSE),
        array('libs/bootbox.js', 'libs/bootbox.js', TRUE, FALSE),
        array('libs/bootstrap.file-input.js', 'libs/bootstrap.file-input.js', TRUE, FALSE),
        array('libs/bootstrap-wizard.js', 'libs/bootstrap-wizard.js', TRUE, FALSE),
        array('global-host-search-box.js', 'global-host-search-box.js', TRUE, FALSE),
        array('node_modules/simple-notify/dist/simple-notify.min.js', 'node_modules/simple-notify/dist/simple-notify.min.js', FALSE, FALSE),
        array('node_modules/chosen-js/chosen.jquery.min.js'),
        array('../themes/default/bootstrap/compiled/js/bootstrap.min.js', '../themes/default/bootstrap/compiled/js/bootstrap.min.js', TRUE, FALSE),
        array('widgets/modal.js'),
        array('node_modules/pluralize/pluralize.js', 'node_modules/pluralize/pluralize.js', TRUE, FALSE),
    )
);

$config['groups']['iefix'] = array(
  'js' => array(
    array('node_modules/html5shiv/dist/html5shiv.min.js','node_modules/html5shiv/dist/html5shiv.min.js',TRUE,FALSE),
    array('node_modules/json2/lib/JSON2/static/json2.js','node_modules/json2/lib/JSON2/static/json2.js',TRUE,FALSE)
  )
);

$config['groups']['footer'] = array(
    'js' => array(
        array('notify.js', 'notify.js', TRUE, TRUE),
	    array('error-logger.js'),
        array('CFE_context_help.js', 'CF_context_help.js', TRUE, TRUE),
        array('useractivity/session_expired_modal.js', 'useractivity/session_expired_modal.js', TRUE, TRUE),
        array('CFE_footer_initialize.js', 'CFE_footer_initialize.js', TRUE, TRUE),
        array('CFE_high_availability_header.js', 'CFE_high_availability_header.js', TRUE, TRUE),
        array('CFE_license_header.js', 'CFE_license_header.js', TRUE, TRUE),
    )
);

