<?php

/**
 * Class Data_transfer
 */
class Data_transfer extends Cf_Controller
{

    /**
     * Data_transfer constructor.
     */
    function __construct()
    {
        parent::__construct();
        setCurrentApplication('data_transfer');
    }

    /**
     * @rbacName View data transfer page
     * @rbacGroup Data transfer
     * @rbacAlias data_transfer.index
     * @rbacAllowedByDefault
     */
    function index()
    {
        $requiredcss = array(
            array('angularjs-ui/angular-ui.css'),
        );

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = array(
            array('node_modules/underscore/underscore-min.js'),
            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),


            // services
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('libs/class.js'),

            array('node_modules/angular-chosen-localytics/dist/angular-chosen.min.js'),
            array('data-transfer.jquery.js'),
        );

        $requiredjs = array(// project
            array('libs/baseclasses/BaseController.js'),
            array('libs/baseclasses/EventDispatcher.js'),
            array('libs/baseclasses/Notifications.js'),

            array('dataTransfer/app.js'),
            array('dataTransfer/controllers/dataTransferController.js'),
            array('dataTransfer/services/dataTransferService.js'),
            array('dataTransfer/directives/importUploader.js'),

        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = array('title' => 'Export / Import - Mission Portal');

        $this->template->load('template', 'data_transfer/index', $data);
    }


    /**
     * @param $partial
     */
    function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }

}
