var INVENTORY_FILTER_OPERATORS   = {
    '<':'<',
    '>':'>',
    '=':'=',
    '!=':'!=',
    '<=':'<=',
    '>=':'>=',
    'NOT LIKE':'nl',
    'ILIKE':'il',
    'NOT ILIKE':'nil',
    'matches':'matches',
    'not_match':'not_match',
    'contains':'contains',
    'not_contain':'not_contain',
    'regex_matches': 'regex_matches',
    'regex_not_match':'regex_not_match',
    'is_reported': 'is_reported',
    'is_not_reported': 'is_not_reported'
};

var Comparison = [
    {"value": "=",    "label": "=",     "ignoreempty": true, "dataType": ['integer', 'real', 'string', 'timestamp'] },
    {"value": "!=",   "label": "!=",    "ignoreempty": true, "dataType": ['integer', 'real', 'string', 'timestamp'] },

    {"value": ">=",   "label": ">=",    "ignoreempty": true, "dataType": ['integer', 'real', 'timestamp'] },
    {"value": ">",    "label": ">",     "ignoreempty": true, "dataType": ['integer', 'real', 'timestamp'] },
    {"value": "<=",   "label": "<=",    "ignoreempty": true, "dataType": ['integer', 'real', 'timestamp'] },
    {"value": "<",    "label": "<",     "ignoreempty": true, "dataType": ['integer', 'real', 'timestamp'] },

    {"value": "IS NULL",      "label": "IS NULL",     "ignoreempty": false, "dataType": ['integer', 'real', 'string'] },
    {"value": "IS NOT NULL",  "label": "IS NOT NULL", "ignoreempty": false, "dataType": ['integer', 'real', 'string'] },

    {"value": "ILIKE",        "label": "LIKE",        "ignoreempty": true, "dataType": ['string'] },
    {"value": "NOT ILIKE",    "label": "NOT LIKE",    "ignoreempty": true, "dataType": ['string'] },

    {"value": "IN",           "label": "IN",          "ignoreempty": true, "dataType": ['integer', 'real', 'string', 'timestamp'] },
    {"value": "NOT IN",       "label": "NOT IN",      "ignoreempty": true, "dataType": ['integer', 'real', 'string', 'timestamp'] },

    {"value": "ANY",          "label": "ANY",         "ignoreempty": true, "dataType": ['array'] },
    {"value": "ALL",          "label": "ALL",         "ignoreempty": true, "dataType": ['array'] }
];

var DefaultComparisions = [];
    DefaultComparisions['integer']   = '=';
    DefaultComparisions['real']      = '=';
    DefaultComparisions['string']    = '=';
    DefaultComparisions['timestamp'] = '=';
    DefaultComparisions['array']     = 'ANY';


var Logical = [
    {"value": "AND",  "label": "AND"},
    {"value": "OR",   "label": "OR"}
];

var Order   = [
    {"value": "ASC",  "label": "ASC"},
    {"value": "DESC", "label": "DESC"}
];

var Limit       = [5, 10, 25,  50, 100, 200, 500, 1000];
var RowsPerPage = [5,     25,  50, 100, 200, 500, 1000];

var ReportCategories = [
    {"value": "changes",                   "label": "Changes"                   },
    {"value": "compliance_report",         "label": "Compliance"                   },
    {"value": "promise_outcomes",          "label": "Promise outcomes"          },
    {"value": "file_integrity_monitoring", "label": "File integrity monitoring" },
    {"value": "inventory",                 "label": "Inventory"                 },
    {"value": "resource_usage",            "label": "Resource usage"            },
    {"value": "software",                  "label": "Software"                  },
    {"value": "uncategorized",             "label": "Uncategorized"             }
];


var DCA_TABLES = {
    'Hosts':
        {
        'TableID': 'Hosts',
        'Keys'   : {'primary_key': 'HostKey' },
        'label'  : 'Hosts',
        'Fields' : {
            'Hosts.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.HostKey',
                "dataType"  : "string"
            },
                    /* not shown
            'Hosts.IsCallCollected': {
                "name"      : "IsCallCollected",
                "label"     : "Is Call Collected",
                "inputType" : "checkbox",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.IsCallCollected',
            }, */
            'Hosts.LastReportTimeStamp': {
                "name"      : "LastReportTimeStamp",
                "label"     : "Last report time",
                "inputType" : "text",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.LastReportTimeStamp',
                "dataType"  : 'timestamp'
            },
            'Hosts.HostName': {
                "name"      : "HostName",
                "label"     : "Host name",
                "inputType" : "text",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.HostName',
                "dataType"  : "string"
            },
            'Hosts.IPAddress': {
                "name"      : "IPAddress",
                "label"     : "IP address",
                "inputType" : "text",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.IPAddress',
                "dataType"  : "string"
            },
            'Hosts.FirstReportTimeStamp': {
                "name"      : "FirstReportTimeStamp",
                "label"     : "First report-time",
                "inputType" : "text",
                "table"     : 'Hosts',
                "sqlField"  : 'Hosts.FirstReportTimeStamp',
                "dataType"  : 'timestamp'
            }
        }
    },

/* -------------------------- AGENTSTATUS  ------------------------------------ */
    'AgentStatus':
        {
        'TableID': 'AgentStatus',
        'Keys'   : {'primary_key': 'HostKey' },
        'label'  : 'Agent Status',
        'Fields' : {
            'AgentStatus.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'AgentStatus',
                "sqlField"  : 'AgentStatus.HostKey',
                "dataType"  : "string"
            },
            'AgentStatus.AgentExecutionInterval': {
                "name"      : "AgentExecutionInterval",
                "label"     : "Agent execution interval",
                "inputType" : "text",
                "table"     : 'AgentStatus',
                "sqlField"  : 'AgentStatus.AgentExecutionInterval',
                "dataType"  : 'integer'
            },
            'AgentStatus.LastAgentLocalExecutionTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Last agent local execution time",
                "inputType" : "text",
                "table"     : 'AgentStatus',
                "sqlField"  : 'AgentStatus.LastAgentLocalExecutionTimeStamp',
                "dataType"  : 'timestamp'
            },
            'AgentStatus.LastAgentExecutionStatus': {
                "name"      : "LastAgentExecutionStatus",
                "label"     : "Last agent execution status",
                "inputType" : "text",
                "table"     : 'AgentStatus',
                "sqlField"  : 'AgentStatus.LastAgentExecutionStatus',
                "dataType"  : "string"
            }
        }
    },

/* -------------------------- CONTEXTS  ------------------------------------ */
// NOTE:
//  context table renamed in UI to classes
//  Context name  renamed in UI to class name.
//  see: https://dev.cfengine.com/issues/5892
//
    'Contexts': {
        'TableID': 'Contexts',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Classes',
        'Fields' : {
            'Contexts.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'Contexts',
                "sqlField"  : 'Contexts.HostKey',
                "dataType"  : "string"
            },
            'Contexts.ContextName': {
                "name"      : "ContextName",
                "label"     : "Class name",
                "inputType" : "text",
                "table"     : 'Contexts',
                "sqlField"  : 'Contexts.ContextName',
                "dataType"  : "string"
            },
            'Contexts.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'Contexts',
                "sqlField"  : 'Contexts.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'Contexts.metatags': {
                "name"      : "metatags",
                "label"     : "Meta tags",
                "inputType" : "text",
                "table"     : 'Contexts',
                "sqlField"  : 'Contexts.metatags',
                "dataType"  : 'timestamp'
            }
        }
    },


/* -------------------------- VARIABLES  ------------------------------------ */
    'Variables': {
        'TableID': 'Variables',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Variables',
        'Fields': {
            'Variables.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.HostKey',
                "dataType"  : "string"
            },
            'Variables.NameSpace': {
                "name"      : "NameSpace",
                "label"     : "Name space",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.NameSpace',
                "dataType"  : "string"
            },
            'Variables.Bundle': {
                "name"      : "Bundle",
                "label"     : "Bundle",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.Bundle',
                "dataType"  : "string"
            },
            'Variables.VariableName': {
                "name"      : "VariableName",
                "label"     : "Variable name",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.VariableName',
                "dataType"  : "string"
            },
            'Variables.VariableValue': {
                "name"      : "VariableValue",
                "label"     : "Variable value",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.VariableValue',
                "dataType"  : "string"
            },
            'Variables.VariableType': {
                "name"      : "VariableType",
                "label"     : "Variable type",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.VariableType',
                "dataType"  : "string"
            },
            // comp is not shown in the UI because we don't think it's useful for users to query by.
            'Variables.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'Variables.metatags': {
                "name"      : "metatags",
                "label"     : "Meta tags",
                "inputType" : "text",
                "table"     : 'Variables',
                "sqlField"  : 'Variables.metatags',
                "dataType"  : 'array'
            }
        }
    },


/* -------------------------- SOFTWARE  ------------------------------------- */

    'Software': {
        'TableID': 'Software',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Software',
        'Fields' : {
            'Software.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'Software',
                "sqlField"  : 'Software.HostKey',
                "dataType"  : "string"
            },

            // compo is not shown

            'Software.SoftwareName': {
                "name"      : "SoftwareName",
                "label"     : "Software name",
                "inputType" : "text",
                "table"     : 'Software',
                "sqlField"  : 'Software.SoftwareName',
                "dataType"  : "string"
            },
            'Software.SoftwareVersion': {
                "name"      : "SoftwareVersion",
                "label"     : "Software version",
                "inputType" : "text",
                "table"     : 'Software',
                "sqlField"  : 'Software.SoftwareVersion',
                "dataType"  : "string"
            },
            'Software.SoftwareArchitecture': {
                "name"      : "SoftwareArchitecture",
                "label"     : "Software architecture",
                "inputType" : "text",
                "table"     : 'Software',
                "sqlField"  : 'Software.SoftwareArchitecture',
                "dataType"  : "string"
            },
            'Software.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'Software',
                "sqlField"  : 'Software.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            }
        }
    },


/* -------------------------- SOFTWAREUPDATES  ---------------------------- */
    'SoftwareUpdates': {
        'TableID': 'SoftwareUpdates',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Software updates',
        'Fields' : {
            'SoftwareUpdates.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.HostKey',
                "dataType"  : "string"
            },

            // compo is not shown

            'SoftwareUpdates.PatchName': {
                "name"      : "PatchName",
                "label"     : "Patch name",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.PatchName',
                "dataType"  : "string"
            },
            'SoftwareUpdates.PatchVersion': {
                "name"      : "PatchVersion",
                "label"     : "Patch version",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.PatchVersion',
                "dataType"  : "string"
            },

            'SoftwareUpdates.PatchArchitecture': {
                "name"      : "PatchArchitecture",
                "label"     : "Patch architecture",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.PatchArchitecture',
                "dataType"  : "string"
            },
            'SoftwareUpdates.PatchReportType': {
                "name"      : "PatchReportType",
                "label"     : "Patch-report type",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.PatchReportType',
                "dataType"  : "string"
            },
            'SoftwareUpdates.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'SoftwareUpdates',
                "sqlField"  : 'SoftwareUpdates.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            }
        }
    },

/* -------------------------- LASTSEENHOSTS  ---------------------------- */
    'LastSeenHosts': {
        'TableID': 'LastSeenHosts',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Last-seen hosts',
        'Fields' : {
            'LastSeenHosts.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.HostKey',
                "dataType"  : "string"
            },

            // compo is not shown


            'LastSeenHosts.LastSeenDirection': {
                "name"      : "LastSeenDirection",
                "label"     : "Last seen direction",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.LastSeenDirection',
                "dataType"  : "string"
            },
            'LastSeenHosts.RemoteHostKey': {
                "name"      : "RemoteHostKey",
                "label"     : "Remote host key",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.RemoteHostKey',
                "dataType"  : "string"
            },
            'LastSeenHosts.RemoteHostIP': {
                "name"      : "RemoteHostIP",
                "label"     : "Remote host IP",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.RemoteHostIP',
                "dataType"  : "string"
            },
            'LastSeenHosts.LastSeenTimeStamp': {
                "name"      : "LastSeenTimeStamp",
                "label"     : "Last seen time",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.LastSeenTimeStamp',
                "dataType"  : "timestamp"
            },
            'LastSeenHosts.LastSeenInterval': {
                "name"      : "LastSeenInterval",
                "label"     : "Last seen interval",
                "inputType" : "text",
                "table"     : 'LastSeenHosts',
                "sqlField"  : 'LastSeenHosts.LastSeenInterval',
                "dataType"  : "real"
            }
        }
    },

    /* -------------------------- PromiseLog  ---------------------------- */
    'PromiseLog': {
        'TableID': 'PromiseLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Promise execution log',
        'Fields' : {
            'PromiseLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.HostKey',
                "dataType"  : "string"
            },
            'PromiseLog.PolicyFile': {
                "name"      : "PolicyFile",
                "label"     : "Policy file",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.PolicyFile',
                "dataType"  : "string"
            },
            'PromiseLog.ReleaseId': {
                "name"      : "ReleaseId",
                "label"     : "Release id",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.ReleaseId',
                "dataType"  : "string"
            },
            'PromiseLog.PromiseHash': {
                "name"      : "PromiseHash",
                "label"     : "Promise hash",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.PromiseHash',
                "dataType"  : "string"
            },
            'PromiseLog.NameSpace': {
                "name"      : "NameSpace",
                "label"     : "Name space",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.NameSpace',
                "dataType"  : "string"
            },
            'PromiseLog.BundleName': {
                "name"      : "BundleName",
                "label"     : "Bundle name",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.BundleName',
                "dataType"  : "string"
            },
            'PromiseLog.PromiseType': {
                "name"      : "PromiseType",
                "label"     : "Promise type",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.PromiseType',
                "dataType"  : "string"
            },
            'PromiseLog.Promiser': {
                "name"      : "Promiser",
                "label"     : "Promiser",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.Promiser',
                "dataType"  : "string"
            },
            'PromiseLog.StackPath': {
                "name"      : "StackPath",
                "label"     : "Stack path",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.StackPath',
                "dataType"  : "string"
            },
            'PromiseLog.PromiseHandle': {
                "name"      : "PromiseHandle",
                "label"     : "Promise handle",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.PromiseHandle',
                "dataType"  : "string"
            },
            'PromiseLog.PromiseOutcome': {
                "name"      : "PromiseOutcome",
                "label"     : "Promise outcome",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.PromiseOutcome',
                "dataType"  : "string"
            },
            'PromiseLog.LogMessages': {
                "name"      : "LogMessages",
                "label"     : "Log messages",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.LogMessages',
                "dataType"  : "array"
            },
            'PromiseLog.Promisees': {
                "name"      : "Promisees",
                "label"     : "Promisees",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.Promisees',
                "dataType"  : "array"
            },
            'PromiseLog.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'PromiseLog',
                "sqlField"  : 'PromiseLog.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            }
        }
    },

/* -------------------------- PromiseExecutions  ---------------------------- */
    'PromiseExecutions': {
        'TableID': 'PromiseExecutions',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Promise executions',
        'Fields' : {
            'PromiseExecutions.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.HostKey',
                "dataType"  : "string"
            },
            'PromiseExecutions.PolicyFile': {
                "name"      : "PolicyFile",
                "label"     : "Policy file",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.PolicyFile',
                "dataType"  : "string"
            },
            'PromiseExecutions.ReleaseId': {
                "name"      : "ReleaseId",
                "label"     : "Release id",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.ReleaseId',
                "dataType"  : "string"
            },
            'PromiseExecutions.PromiseHash': {
                "name"      : "PromiseHash",
                "label"     : "Promise hash",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.PromiseHash',
                "dataType"  : "string"
            },

            'PromiseExecutions.NameSpace': {
                "name"      : "NameSpace",
                "label"     : "Name space",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.NameSpace',
                "dataType"  : "string"
            },
            'PromiseExecutions.BundleName': {
                "name"      : "BundleName",
                "label"     : "Bundle name",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.BundleName',
                "dataType"  : "string"
            },
            'PromiseExecutions.PromiseType': {
                "name"      : "PromiseType",
                "label"     : "Promise type",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.PromiseType',
                "dataType"  : "string"
            },
            'PromiseExecutions.Promiser': {
                "name"      : "Promiser",
                "label"     : "Promiser",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.Promiser',
                "dataType"  : "string"
            },
            'PromiseExecutions.StackPath': {
                "name"      : "StackPath",
                "label"     : "Stack path",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.StackPath',
                "dataType"  : "string"
            },
            'PromiseExecutions.PromiseHandle': {
                "name"      : "PromiseHandle",
                "label"     : "Promise handle",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.PromiseHandle',
                "dataType"  : "string"
            },
            'PromiseExecutions.PromiseOutcome': {
                "name"      : "PromiseOutcome",
                "label"     : "Promise outcome",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.PromiseOutcome',
                "dataType"  : "string"
            },
            'PromiseExecutions.LogMessages': {
                "name"      : "LogMessages",
                "label"     : "Log messages",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.LogMessages',
                "dataType"  : "array"
            },
            'PromiseExecutions.Promisees': {
                "name"      : "Promisees",
                "label"     : "Promisees",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.Promisees',
                "dataType"  : "array"
            },
            'PromiseExecutions.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'PromiseExecutions',
                "sqlField"  : 'PromiseExecutions.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            }
        }
    },

// inventory is not shown

/* -------------------------- ContextsLog  ---------------------------- */
// NOTE:
//  context table renamed in UI to classes
//  Context name  renamed in UI to class name.
//  see: https://dev.cfengine.com/issues/5892
//
    'ContextsLog': {
        'TableID': 'ContextsLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Classes log',
        'Fields' : {
            'ContextsLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'ContextsLog',
                "sqlField"  : 'ContextsLog.HostKey',
                "dataType"  : "string"
            },
            'ContextsLog.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'ContextsLog',
                "sqlField"  : 'ContextsLog.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'ContextsLog.ChangeOperation': {
                "name"      : "ChangeOperation",
                "label"     : "Change operation",
                "inputType" : "text",
                "table"     : 'ContextsLog',
                "sqlField"  : 'ContextsLog.ChangeOperation',
                "dataType"  : "string"
            },
            'ContextsLog.ContextName': {
                "name"      : "ContextName",
                "label"     : "Class name",
                "inputType" : "text",
                "table"     : 'ContextsLog',
                "sqlField"  : 'ContextsLog.ContextName',
                "dataType"  : "string"
            }

            //MetaTags is not shown

        }
    },

/* -------------------------- VariablesLog  ---------------------------- */
    'VariablesLog': {
        'TableID': 'VariablesLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Variables log',
        'Fields' : {
            'VariablesLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.HostKey',
                "dataType"  : "string"
            },
            'VariablesLog.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'VariablesLog.ChangeOperation': {
                "name"      : "ChangeOperation",
                "label"     : "Change operation",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.ChangeOperation',
                "dataType"  : "string"
            },
            'VariablesLog.NameSpace': {
                "name"      : "NameSpace",
                "label"     : "Name space",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.NameSpace',
                "dataType"  : "string"
            },
            'VariablesLog.Bundle': {
                "name"      : "Bundle",
                "label"     : "Bundle",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.Bundle',
                "dataType"  : "string"
            },
            'VariablesLog.VariableName': {
                "name"      : "VariableName",
                "label"     : "Variable name",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.VariableName',
                "dataType"  : "string"
            },
            'VariablesLog.VariableValue': {
                "name"      : "VariableValue",
                "label"     : "Variable value",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.VariableValue',
                "dataType"  : "string"
            },
            'VariablesLog.VariableType': {
                "name"      : "VariableType",
                "label"     : "Variable type",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.VariableType',
                "dataType"  : "string"
            },
            'VariablesLog.metatags': {
                "name"      : "metatags",
                "label"     : "Meta tags",
                "inputType" : "text",
                "table"     : 'VariablesLog',
                "sqlField"  : 'VariablesLog.metatags',
                "dataType"  : "array"
            }
        }
    },


/* -------------------------- SoftwareLog  ---------------------------- */
    'SoftwareLog': {
        'TableID': 'SoftwareLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Software log',
        'Fields' : {
            'SoftwareLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.HostKey',
                "dataType"  : "string"
            },
            'SoftwareLog.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'SoftwareLog.ChangeOperation': {
                "name"      : "ChangeOperation",
                "label"     : "Change operation",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.ChangeOperation',
                "dataType"  : "string"
            },
            'SoftwareLog.SoftwareName': {
                "name"      : "SoftwareName",
                "label"     : "Software name",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.SoftwareName',
                "dataType"  : "string"
            },
            'SoftwareLog.SoftwareVersion': {
                "name"      : "SoftwareVersion",
                "label"     : "Software Version",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.SoftwareVersion',
                "dataType"  : "string"
            },
            'SoftwareLog.SoftwareArchitecture': {
                "name"      : "SoftwareArchitecture",
                "label"     : "Software architecture",
                "inputType" : "text",
                "table"     : 'SoftwareLog',
                "sqlField"  : 'SoftwareLog.SoftwareArchitecture',
                "dataType"  : "string"
            }
        }
    },


/* -------------------------- FileChangesLog  ------------------------------------ */
    'FileChangesLog': {
        'TableID': 'FileChangesLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'File-changes log',
        'Fields' : {
            'FileChangesLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.HostKey',
                "dataType"  : "string"
            },
            'FileChangesLog.PromiseHandle': {
                "name"      : "PromiseHandle",
                "label"     : "Promise handle",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.PromiseHandle',
                "dataType"  : "string"
            },
            'FileChangesLog.FileName': {
                "name"      : "FileName",
                "label"     : "File name",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.FileName',
                "dataType"  : "string"
            },
            'FileChangesLog.ChangeTimeStamp': {
                "name"      : "ChangeTimeStamp",
                "label"     : "Change time",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.ChangeTimeStamp',
                "dataType"  : 'timestamp'
            },
            'FileChangesLog.ChangeType': {
                "name"      : "ChangeType",
                "label"     : "Change type",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.ChangeType',
                "dataType"  : "string"
            },
            'FileChangesLog.ChangeDetails': {
                "name"      : "ChangeDetails",
                "label"     : "Change details",
                "inputType" : "text",
                "table"     : "FileChangesLog",
                "sqlField"  : 'FileChangesLog.ChangeDetails',
                "dataType"  : "array"
            }
        }
    },

/* -------------------------- BenchmarksLog  ---------------------------- */
    'BenchmarksLog': {
        'TableID': 'BenchmarksLog',
        'Keys'   : {'primary_key': 'HostKey'},
        'label'  : 'Benchmarks log',
        'Fields' : {
            'BenchmarksLog.HostKey': {
                "name"      : "HostKey",
                "label"     : "Host key",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.HostKey',
                "dataType"  : "string"
            },
            'BenchmarksLog.EventName': {
                "name"      : "EventName",
                "label"     : "Event name",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.EventName',
                "dataType"  : "string"
            },
            'BenchmarksLog.StandardDeviation': {
                "name"      : "StandardDeviation",
                "label"     : "Standard deviation",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.StandardDeviation',
                "dataType"  : "real"
            },
            'BenchmarksLog.AverageValue': {
                "name"      : "AverageValue",
                "label"     : "Average value",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.AverageValue',
                "dataType"  : "real"
            },
            'BenchmarksLog.LastValue': {
                "name"      : "LastValue",
                "label"     : "Last value",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.LastValue',
                "dataType"  : "real"
            },
            'BenchmarksLog.CheckTimeStamp': {
                "name"      : "CheckTimeStamp",
                "label"     : "Check time",
                "inputType" : "text",
                "table"     : 'BenchmarksLog',
                "sqlField"  : 'BenchmarksLog.CheckTimeStamp',
                "dataType"  : "timestamp"
            }
        }
    },
};

var DefaultInventoryFilterClasses = [
    'centos',
    'coreos',
    'redhat_pure',
    'debian_pure',
    'SUSE',
    'ubuntu',
    'solaris',
    'hpux',
    'aix',
    'windows'
];
