'use strict';
/*
 * Service to controll pagination
 *
 */

var paginationService = Class.extend({


    defaultRowsPerPage: 10,

    page: 1, // current page
    pages: 1, // how many pages we have after query

    rowsPerPageList:   [5, 10, 25, 50, 100, 200],
    rowsPerPage: 10, // current value from rows per page


    // result related variables
    resultCount: 0, // how many rows in result
    skip: 0, // used for limit

    resultPagesList: [], // show links list 1,2,3..


    setPages: function (resultCount) {
        this.resultCount = resultCount;
        this.pages = Math.ceil(resultCount / this.rowsPerPage);
    },
    refreshPaginator: function (resultCount) {

        this.setPages(resultCount);

        var start = 0;
        var end = 0;

        this.resultPagesList = [];

        if (this.pages >= 5) {

            if (this.page > 3 && this.page < (this.pages - 1)) {
                start = this.page - 2;
                end = this.page + 2;
            }
            else if (this.page === (this.pages - 1) || this.page === this.pages) {
                start = this.pages - 4;
                end = this.pages;
            }
            else {
                start = 1;
                end = 5;
            }
        }
        else {
            start = 1;
            end = this.pages;
        }

        for (start; start <= end; start++) {
            this.resultPagesList.push(start);
        }
    },
    paginationReset: function () {
        this.page = 1;
        this.pages = 1;
        this.skip = 0;
        this.resultCount = 0;
        this.resultPagesList = [];
        // here we do not reset rowsPerPage as the user may have selected something other than the default and wish it to remain
    },
    reloadView: function (page) {
        var newPage = page;

        if (this.page === page) {
            return;
        }

        if (page < 1) {
            newPage = 1;
        }

        if (page > this.pages) {
            newPage = this.page;
        }

        if (this.page !== newPage) {
            this.page = newPage;

            if (this.page === 1) {
                this.skip = 0;
            }
            else {
                this.skip = (this.page - 1) * this.rowsPerPage;
            }
        }

        if (this.resultCount) {
            this.$rootScope.$broadcast('paginatorChange');
        }
    },
    setRowsPerPage: function (val) {
        if (val !== '') {
            this.rowsPerPage = val;
            this.page = 1;
            this.setPages(this.resultCount);
            this.skip = 0;

            this.$rootScope.$broadcast('paginatorChange');
        }
    },
    _setDefaultRowsPerPage: function () {
        return this.defaultRowsPerPage;
    },

    getResultsOnPage: function () {

        if (this.page === this.pages) {
            return (this.resultCount % this.rowsPerPage) || this.rowsPerPage;
        } else {
            return Math.min(this.resultCount, this.rowsPerPage);
        }
    }

});

(function () {

    var paginationServiceProvider = Class.extend({
        instance: new paginationService(),
        $get: ['$rootScope', function ($rootScope) {
            this.instance.$rootScope = $rootScope;
            return this.instance;
        }]
    });

    angular.module('inclExcl.paginationServiceModule', [])
        .provider('IEPaginationService', paginationServiceProvider);
}());
