<?php

class RandomGenerator
{
    const PREFIXES = ['web', 'app', 'db', 'api', 'cache', 'proxy', 'auth', 'admin', 'cdn', 'static', 'worker', 'queue', 'backup', 'monitor', 'report'];
    const ENVIRONMENTS = ['prod', 'dev', 'stage', 'test'];
    const LOCATIONS = ['east', 'west', 'north', 'south', 'central'];
    const COLORS = ['red', 'blue', 'green', 'yellow', 'purple', 'orange', 'pink', 'cyan'];
    const ANIMALS = ['lion', 'tiger', 'bear', 'wolf', 'eagle', 'falcon', 'dolphin', 'shark', 'panther', 'cobra'];

    const OS = ['centos', 'ubuntu', 'suse', 'debian_pure'];

    public static function name(): string
    {
        $nameArray = [
            self::PREFIXES[array_rand(self::PREFIXES)],
            self::ENVIRONMENTS[array_rand(self::ENVIRONMENTS)],
            self::LOCATIONS[array_rand(self::LOCATIONS)],
            self::COLORS[array_rand(self::COLORS)],
            self::ANIMALS[array_rand(self::ANIMALS)],
            mt_rand(1, 999)
        ];

        return implode('-', $nameArray);
    }

    public static function ip(): string
    {
        return long2ip(mt_rand(0, 4294967295));
    }

    public static function hostkey(): string
    {
        return 'SHA=' . hash('sha256', random_bytes(32));
    }

    public static function os(int $i): string
    {
        return self::OS[$i % count(self::OS)];
    }
}
