<!-- POLICY -->
<div ng-if="ruleData['type']=='policy'">
    <div>
        <label class="control-label" >
            <div class="btn-group" style="margin-top:-5px">
                <button ng-class="{'disabled':alertData.ruleid}" data-toggle="dropdown" class="btn dropdown-toggle">
                    <span ng-show="ruleData.policyConditions.filterBy != ''">{{ruleData.policyConditions.filterBy | DCA_ValueToString:'Policy_TypeFilter'}}</span>
                    <span ng-hide="ruleData.policyConditions.filterBy">Choose a filter</span>
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu pull-right">
                    <li ng-repeat="(itemId, item) in DCA.Policy_TypeFilter">
                        <a ng-click="setPolicyConditionType(item.value)" href="javascript:void(0)">{{item.label}}</a>
                    </li>
                </ul>
            </div>
        </label>

        <div class="controls">
            <div>
                <div class="btn-group">
                    <input type="text"
                           autocomplete="off"
                           ng-model="ruleData.policyConditions.filterItemName"
                           typeahead-editable="true"
                           typeahead-wait-ms="1000"
                           typeahead="item for item in autocompleteList(ruleData.policyConditions.filterBy, $viewValue) | limitTo:15"
                           class="input-large"
                           ng-readonly="alertData.ruleid || !ruleData.policyConditions.filterBy">
                </div>
                <div class="help-block">
                    <span ng-show="ruleData.policyConditions.filterBy">
                        Select <span class="lowercase">{{ruleData.policyConditions.filterBy | DCA_ValueToString:'Policy_TypeFilter'}}</span> name
                    </span>
                     <span class="help-block">Leave empty to apply to all policy</span>
                </div>
            </div>
        </div>
    </div>

    <div class="margin-top-small">
        <label class="control-label">
            <span>Promise handle</span>
        </label>

        <div class="controls">
            <div class="btn-group">
                <input type="text"
                       autocomplete="off"
                       ng-model="ruleData.policyConditions.promisehandle"
                       typeahead-editable="true"
                       typeahead-wait-ms="1000"
                       typeahead="item for item in autocompleteList('promisehandle', $viewValue, ruleData.policyConditions.filterBy, ruleData.policyConditions.filterItemName) | limitTo:15"
                       class="input-large"
                       ng-readonly="ruleData.id">
            </div>
 <?php /* TODO: implement missing functionality to accept more than one promise handle
           <span class="help-block">Comma separated list</span> */?>
        </div>
    </div>
    <div class="margin-top-small required" ng-class="{error:alertEdit.$dirty && !ruleData.policyConditions.promiseoutcome}">
        <label class="control-label">
            <span>Promise status</span>
        </label>

        <div class="controls" id="promise-status">

            <select
                required
                data-placeholder="Select status"
                chozen
                ng-model="ruleData.policyConditions.promiseoutcome"
                watch="DCA.Policy_Promiseoutcome"
                ng-options="outcome.value as outcome.value | DCA_ValueToString:'Policy_Promiseoutcome' for outcome in DCA.Policy_Promiseoutcome"
                disable="ruleData.id"
                >
            </select>

            <span class="help-block error" ng-show="alertEdit.$dirty && !ruleData.policyConditions.promiseoutcome">You must choose a promise status.</span>

            <input type="hidden" ng-model="ruleData.policyConditions.promiseoutcome" required>
        </div>
    </div>
</div>