<?php

namespace events\dto;

readonly class UserEventsDto
{
    public function __construct(
        public string  $username = '',
        public ?string $email = null,
        public ?string $oauthToken = null,
        public bool $isPasswordReset = false,
        public ?\CfUsers $cfUser = null,
        public ?array $updatedData = null,
    ) {
    }

    public static function fromArray(array $data): self
    {
        return new self(
            $data['username'] ?? '',
            $data['email'] ?? null,
            $data['oauthToken'] ?? null,
            $data['isPasswordReset'] ?? false,
            $data['cfUser'] ?? null,
            $data['updatedData'] ?? null,
        );
    }
}
