<?php
/**
 * Created by PhpStorm.
 * User: ialeksandrychev
 * Date: 20.07.17
 * Time: 12:59
 */

namespace models\compositers;

use models\dataMappers\LdapUserAdapterInterface;
use models\dataMappers\UserMapperInterface;

class UsersCompositor implements MappableInterface
{
    private $users;
    private $adapter;

    private $mappedUsers = [];

    public function __construct(array $users, LdapUserAdapterInterface $adapter)
    {
        $this->users = $users;
        $this->adapter = $adapter;
    }

    public function map()
    {
        foreach($this->users as $user)
        {
            $this->adapter->setLdapUser($user);
            $this->mappedUsers[] = $this->adapter->toArray();
        }

        return $this->mappedUsers;
    }
}