var globalLogger = {
    getBrowserVersion: (function () {
        var ua = navigator.userAgent, tem,
            M = ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
        if (/trident/i.test(M[1])) {
            tem = /\brv[ :]+(\d+)/g.exec(ua) || [];
            return 'IE ' + (tem[1] || '');
        }
        if (M[1] === 'Chrome') {
            tem = ua.match(/\b(OPR|Edge)\/(\d+)/);
            if (tem != null) return tem.slice(1).join(' ').replace('OPR', 'Opera');
        }
        M = M[2] ? [M[1], M[2]] : [navigator.appName, navigator.appVersion, '-?'];
        if ((tem = ua.match(/version\/(\d+)/i)) != null) M.splice(1, 1, tem[1]);
        return M.join(' ');
    })(),

    sendErrorToServer: function (message) {
        if(MP_LOG_JS_ERROR === true){
            var xhttp = new XMLHttpRequest();
            message += ' Browser version: ' + this.getBrowserVersion;
            xhttp.open("POST", "/logger/log", true);
            xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhttp.send("error=" + encodeURIComponent('Client-side JS error:: ' + message));
        }
    }
};

window.onerror = function (msg, url, line, col) {
    var msg = "Error: " + msg + "\nurl: " + url + "\nline: " + line + ':' + col;
    globalLogger.sendErrorToServer(msg)
};