"use strict";
"use client";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextAppDirEmotionCacheProvider = void 0;
const react_1 = __importDefault(require("react"));
const cache_1 = __importDefault(require("@emotion/cache"));
const navigation_1 = require("next/navigation");
const react_2 = require("react");
const react_3 = require("@emotion/react");
function NextAppDirEmotionCacheProvider(props) {
    const { options: optionsWithPrepend, CacheProvider = react_3.CacheProvider, children } = props;
    const { prepend = false } = optionsWithPrepend, options = __rest(optionsWithPrepend, ["prepend"]);
    const [{ cache, flush }] = (0, react_2.useState)(() => {
        const cache = (0, cache_1.default)(options);
        cache.compat = true;
        const prevInsert = cache.insert;
        let inserted = [];
        cache.insert = (...args) => {
            const [selector, serialized] = args;
            if (cache.inserted[serialized.name] === undefined) {
                inserted.push({
                    "name": serialized.name,
                    "isGlobal": selector === ""
                });
            }
            return prevInsert(...args);
        };
        const flush = () => {
            const prevInserted = inserted;
            inserted = [];
            return prevInserted;
        };
        return { cache, flush };
    });
    (0, navigation_1.useServerInsertedHTML)(() => {
        const inserted = flush();
        if (inserted.length === 0) {
            return null;
        }
        let styles = "";
        let dataEmotionAttribute = cache.key;
        const globals = [];
        for (const { name, isGlobal } of inserted) {
            const style = cache.inserted[name];
            if (typeof style === "boolean") {
                continue;
            }
            if (isGlobal) {
                globals.push({ name, style });
            }
            else {
                styles += style;
                dataEmotionAttribute += ` ${name}`;
            }
        }
        const get__Html = (style) => prepend ? `@layer emotion {${style}}` : style;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            globals.map(({ name, style }) => (react_1.default.createElement("style", { nonce: options.nonce, key: name, "data-emotion": `${cache.key}-global ${name}`, dangerouslySetInnerHTML: { "__html": get__Html(style) } }))),
            styles !== "" && (react_1.default.createElement("style", { nonce: options.nonce, "data-emotion": dataEmotionAttribute, dangerouslySetInnerHTML: {
                    "__html": get__Html(styles)
                } }))));
    });
    return react_1.default.createElement(CacheProvider, { value: cache }, children);
}
exports.NextAppDirEmotionCacheProvider = NextAppDirEmotionCacheProvider;
exports.default = NextAppDirEmotionCacheProvider;
