<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';

class SshKey extends Cf_REST_Controller
{
    private $endpoint = '/ssh-key';

    public function key_post()
    {
        try {
            $result = $this->getRestClient()->post($this->endpoint);
            $this->respond_ok($result);
        } catch (Exception $exception) {
            respond_internal_error($exception->getMessage());
        }
    }

    public function key_get($id)
    {
        try {
            $result = $this->getRestClient()->get("{$this->endpoint}/$id");
            $this->respond_ok($result);
        } catch (HttpClient_NotFound $exception) {
            respond_not_found();
        } catch (Exception $exception) {
            respond_internal_error($exception->getMessage());
        }
    }

    public function key_delete($id)
    {
        try {
            $this->getRestClient()->delete("{$this->endpoint}/$id");
            $this->respond_ok();
        } catch (HttpClient_NotFound $exception) {
            respond_not_found();
        } catch (Exception $exception) {
            respond_internal_error($exception->getMessage());
        }
    }
}
