<main>
    <div>
        <ol class="breadcrumb margin-top">
            <li><a href="<?= site_url('reports/compliance') ?>">Compliance report</a></li>
            <li class="active">Import report</li>
        </ol>
        <div class="pageTitle">
            <h1>
                <span>Import report</span>
            </h1>
            <div class="margin-top-large">
                <button class="btn btn-primary" onclick="document.getElementById('importFile').click()">
                    <i style="color:white" class="bi bi-file-arrow-up"></i> Select a file
                </button>
                <span ng-if="import.fileName" class="label label-info ng-binding"
                      id="upload-file-info">{{ import.fileName }}</span>
            </div>
            <input select-file
                   type="file"
                   name="importFile"
                   accept=".json"
                   onclick="this.value=null"
                   class="hide"
                   id="importFile">

            <div ng-if="import.fileName" class="margin-top-large">
                <hr/>
                <h3>To be imported:</h3>
                <h4>Reports</h4>
                <ul>
                    <li ng-repeat="(report, exists) in import.reports">{{ report }} <span ng-if="exists" class="muted">already exists</span>
                    </li>
                </ul>
                <h4>Conditions</h4>
                <ul>
                    <li ng-repeat="(condition, exists) in import.conditions">{{ condition }}
                        <span ng-if="exists" class="muted">already exists</span>
                    </li>
                </ul>
                <div class="margin-top-large">
                    <div ng-if="import.duplicates">
                        <div class="alert alert-error">
                            <span ng-if="import.duplicates.reports.length" class="margin-bottom-large">
                                There {{ import.duplicates.reports.length > 1 ? 'are already different reports' : 'is already a different report' }}
                                with the same name: <span ng-repeat="report in import.duplicates.reports">
                                    <b>{{ report }}</b>{{ $last ? '' : ',' }} </span> - please rename or delete it before importing.
                            </span>
                            <span ng-if="import.duplicates.conditions.length">
                                There {{ import.duplicates.conditions.length > 1 ? 'are already conditions' : 'is already a condition' }}
                                with the same name: <span ng-repeat="condition in import.duplicates.conditions">
                                    <b>{{ condition }}</b>{{ $last ? '' : ',' }} </span> - please rename or delete it before importing.
                            </span><br>
                        </div>
                    </div>
                    <hr/>
                    <button class="btn btn-primary btn-large" ng-click="importReport()" ng-if="!overwrite">Import
                    </button>
                    <button class="btn btn-danger btn-large" ng-click="importReport(true)" ng-if="overwrite">Import and
                        overwrite existing reports and conditions
                    </button>
                    <button class="btn btn-default btn-large" ng-click="clearData()">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</main>
