// version 0.1
(function($) {
    $.widget('ui.astrolabe', {
        options: {
            baseUrl: '../',
            defaultbehaviour: true,
            defaultPerPage: 50,
            noCategoryLabel: "hosts without category",
            accessDeniedResponse: "Access denied"
        },

        _create: function() {
            var $self = this;

            $self.element.addClass('astrolabe');

            $self._menuContainer = $self._createMenu();

            $self._scrollable_list = $('<div id="scrollable_list">');


            $self._listContainer = $('<div>');
            $self._listContainer.addClass('listContainer');
            $self._rootContainer = $('<ul>');
            $self._rootContainer.addClass('rootContainer');


            $self._listContainer.append($self._rootContainer);
            $self._scrollable_list.append($self._listContainer);
            $self._menuContainer.insertBefore($self.element);
            $self.element.append($self._scrollable_list);

        },

        _init: function() {
            var $self = this;
            $self._selected = null;
            $self._uniqueIdCounter = 0;

            $self._loadProfileList();

            $('#astrolabe').on('click', 'li.host > span.hostIcon,li.host > span.hostLabel', function(e) {
                var $li = $(this).closest('li.host');
                $self._onClickHost($self, $li, e);
            });

            $self.hostsLazyLoadingWatcher();

            let currentUrl = location.href;
            window.addEventListener('popstate', () => {
                if (location.href !== currentUrl) {
                    currentUrl = location.href;
                    window.location = currentUrl;  // or handle as needed
                }
            });
        },


        _expandCurrentContext: function(expandPath) {
            var $self = this;
            var nodes = expandPath.nodes == undefined ? null : JSON.parse(expandPath.nodes);
            var host = expandPath.hostkey || null;
            var node = {};
            if (nodes !== null && nodes.length) {
                var selector = $.map(nodes, function(value) {
                    return 'li[label="' + value + '"]';
                }).join(' > ul > ');

                node = $(selector);
            }
            if (!node.length) {
                node = $self._superNode;
            }

            $self._setNodeExpanded(node, true);

            $self._loadNode(node, false).then(function() {
                // timming issue .. has to do after load host is complete
                var hostFound = false;
                var $hostItem = false;
                if (host) {
                    $hostItem = node.find('li[hostkey="' + host + '"]');
                    if ($hostItem.length) {
                        hostFound = true;
                    }
                }

                // check if hostkey var is defined in typeof way that does not throw an error if not
                if (typeof hostkey !== 'undefined' && hostkey != '' && !hostFound) {
                    // if a host is not found in the host tree but URL contains a hostkey then load host info
                    // into the right sidebar without selecting it
                    $self._trigger('notFoundHostSelected', {}, hostkey);
                }  else if (hostFound && $hostItem) {
                    $self._onClickHost($self, $hostItem, null);
                } else {
                    $self._onClickNodeLabel($self, node, null);
                }
            });

            // load the host for other expanded nodes
            for ($n = $self._parentNode(node); $n !== null; $n = $self._parentNode($n)) {
                $self._loadNode($n, false);
            }
        },

        refresh: function() {
            this._profilesCombo.combobox('refresh');
        },

        _createMenu: function() {
            var $self = this;
            var $menuContainer = $('<div>');
            $menuContainer.addClass('menu');

            $self._profilesCombo = $('<div>');
            $self._profilesCombo.addClass('profilesCombo');
            $self._profilesCombo.combobox({
                noneSelectedLabel: 'Uncategorized',
                addItemPlaceholder: 'Add Tree',
                itemExistsError: 'Tree already exists, please choose a different name',
                baseUrl: $self.options.baseUrl,

                itemSelected: function (event, args) {
                    var itemId = args.id;
                    if (itemId && itemId !== '') {
                        $self._loadProfile(itemId, args.defaultProfile, args.sharedTree, args.sharedFrom).then(function () {
                            var path = $self.getPathForTreeExpansion();
                            $self._expandCurrentContext(path);
                        });
                    } else {
                        // we have no id
                        $self._createSuperNode(null, true);
                        $self._recount();
                        var path = $self.getPathForTreeExpansion();
                        $self._expandCurrentContext(path);
                    }
                },

                itemAdded: function(event, args) {
                    $self._saveProfile(args.id, null, args.nodes, args.targetItem, args.sharedPermission, args.global);
                },

                itemDeleted: function(event, args) {
                    $self._deleteProfile(args.id);
                }
            });
            $menuContainer.append($self._profilesCombo);

            return $menuContainer;
        },

        getPathForTreeExpansion: function() {
            var node = $.cookie('sPath');
            var pathObj = {
                nodes: node
            };
            return pathObj;
        },

        setPathForTreeExpansion: function($path) {
            $path = $path || null;
            if ($path !== null) {
                $.cookie('sPath', JSON.stringify($path));
            }
        },

        _isNodeExpanded: function($node) {
            return $node === null || $node.hasClass('expanded');
        },

        _setNodeExpanded: function($node, expanded) {
            var self = this;

            if ($node === null || $node === undefined)
                return;
            if (self._isNodeExpanded($node)) {
                if (expanded === false) {
                    $node.removeClass('expanded').find('.nodeIcon').removeClass('bi-caret-down-fill');
                    $node.find('.nodeIcon').addClass('bi-caret-right-fill');
                    self._nodeContainer($node).hide();
                }
            }
            else {

                if (expanded === true) {
                    $node.addClass('expanded').children('.nodeWrapper').find('.nodeIcon').addClass('bi-caret-down-fill');
                    $node.children('.nodeWrapper').find('.bi-caret-down-fill').removeClass('bi-caret-right-fill');
                    self._setNodeExpanded(self._parentNode($node), true);

                    self._nodeContainer($node).show();
                }
            }
        },

        _onClickNodeLabel: function($self, $node, event) {
            $self._selectElement($node);
            var $path = $self._nodeLabels($node).reverse();
            $self.setPathForTreeExpansion($path);
            $self._trigger('nodeSelected', event, {
                path: $path,
                includes: $self._nodeIncludes($node),
                excludes: $self._nodeExcludes($node),
                count: $node.attr('count')
            });

            if (event !== null && event !== undefined) {
                event.stopPropagation();
            }
        },

        _onClickNodeIcon: function(self, node, event) {
            self._setNodeExpanded(node, !self._isNodeExpanded(node));

            if (self._isNodeExpanded(node)) {
                self._loadNode(node, true);
            }

            if (event !== null && event !== undefined) {
                event.stopPropagation();
            }
        },

        _selectElement: function($element) {
            var $self = this;

            if ($self._selected !== null) {
                $self._selected.removeClass('selectedElement');
            }

            $self._selected = $element;
            $self._selected.addClass('selectedElement');
        },

        _onClickHost: function($self, $host, event) {
            $self._selectElement($host);
            const hostkey = $host.attr('hostkey');
            // this host tree is using not only on the hosts page, but url replacement should happen only on hosts page
            if (location.pathname.split('/')[1] === 'hosts') {
                window.history.pushState({}, `Host ${hostkey}`, `/hosts/${hostkey}`);
            }
            var parentNode = $self._parentNode($host);
            var $path = $self._nodeLabels(parentNode).reverse();

            $self._trigger('hostSelected', event, {
                hostKey: hostkey,
                hostName: $host.attr('hostname').htmlSpecialChars()
            });

            $self.setPathForTreeExpansion($path);
            if (event !== null && event !== undefined) {
                event.stopPropagation();
            }
        },

        _createNode: function (label, classRegex, children, isRemovable, superNode, excludes) {
            var $self = this;


            var $nodeItem = $('<li>').attr('id',common.randomUUID());
            $nodeItem.addClass('node');
            $nodeItem.attr('label', label);
            $nodeItem.attr('class-regex', classRegex);
            $nodeItem.attr('excludes-regex', excludes);

            // hide "without category" , then show when it will have hosts
            if(label == $self.options.noCategoryLabel && isRemovable === false){
                $nodeItem.css('display', 'none');
            }

            var $wrapperElement = $('<div>').addClass('nodeWrapper');
            $nodeItem.append($wrapperElement);

            var $iconElement = $('<span>');
            $iconElement.addClass('nodeIcon bi bi-caret-right-fill');
            $iconElement.click(function(event) {
                $self._onClickNodeIcon($self, $nodeItem, event);
            });
            $wrapperElement.append($iconElement);

            var $nodeHeader = $('<div>');
            $nodeHeader.addClass('nodeHeader');
            $wrapperElement.append($nodeHeader);

            var $labelandCount=$('<div class="toolTipWrapper">').attr({
                'rel':'tooltip',
                'data-placement':'right',
                'title':classRegex
            });
            var $labelElement = $('<span>');
            $labelElement.addClass('nodeLabel');
            $labelElement.text(label);

            $labelElement.click(function(event) {
                $self._onClickNodeLabel($self, $nodeItem, event);
            });

            $labelElement.appendTo($labelandCount);

            var $hostCountLabelElement = $('<span>');
            $hostCountLabelElement.addClass('hostCountLabel');
            $hostCountLabelElement.click(function(event) {
                $self._onClickNodeLabel($self, $nodeItem, event);
            });

            $hostCountLabelElement.appendTo($labelandCount);

            $nodeHeader.append($labelandCount);

            var $addNodeButton = $('<i>');
            $addNodeButton.addClass('addNodeButton bi bi-plus-lg');
            $addNodeButton.click(function(event) {
                var $dialog = $self._nodeDialog($nodeItem, 'Add');
                $dialog.dialog('open');
            });

            var $removeNodeButton = $('<i>');
            $removeNodeButton.addClass('removeNodeButton bi bi-x-lg');
            $removeNodeButton.click(function(event) {
                var $parentNode = $self._parentNode($nodeItem);
                var $title='Remove this node?';
                var $message='Are you sure you want to permanently remove this tree node?';
                $self._confirmationDialog($title,$message,function(){
                    $nodeItem.remove();
                    $self._updateProfile($self._currentProfile, $parentNode);
                    $self.refresh();
                });
            });

            var $editNodeButton = $('<i>');
            $editNodeButton.addClass('editNodeButton bi bi-pencil-fill');
            $editNodeButton.click(function(event) {
                var $dialog = $self._nodeDialog($nodeItem, 'Update');
                $dialog.dialog('open');
            });


            if (isRemovable === true) {
                $nodeHeader.append($addNodeButton);
                if (!superNode) {
                    $nodeHeader.append($editNodeButton);
                    $nodeHeader.append($removeNodeButton);
                }
            }

            var $childrenList = $self._createContainer(children,isRemovable);


            $childrenList.hide();
            $nodeItem.append($childrenList);

            return $nodeItem;
        },
        _nodeDialog: function(parentNode,operation) {
            var $self = this;

            var validation = function() {
                var label = $('#astrolabe-add-node-label').val();
                if (label == '') {
                    $('#astrolabe-add-node-label').focus();
                    $('#astrolabe-add-node-label-error').html('Label cannot be empty');
                    return false;
                }
                else if (!/^[a-zA-Z0-9 _-]{1,100}$/.test(label)) {
                    $('#astrolabe-add-node-label').focus();
                    $('#astrolabe-add-node-label-error').text('Label can only contain alphanumeric characters, spaces, "_" or "-" (max 100 characters)');
                    return false;
                }

                var classRegex = $('#astrolabe-add-node-class').val();
                if (classRegex == '') {
                    $('#astrolabe-add-node-class').focus();
                    $('#astrolabe-add-node-class-error').html('Class regex cannot be empty');
                    return false;
                }
                else if (!common.isValidClassExpression(classRegex)) {
                    $('#astrolabe-add-node-class').focus();
                    $('#astrolabe-add-node-class-error').html('Invalid class regex');
                    return false;
                }

                return {
                    label: label,
                    classRegex: classRegex
                };
            };

            var addNode = function($dialog) {
                $('#astrolabe-add-node-label-error').html('');
                $('#astrolabe-add-node-class-error').html('');
                var nodeprop = validation();
                if (nodeprop === false) {
                    return;
                }

                var $node = $($self._createNode(nodeprop.label, nodeprop.classRegex, null,true));
                var $parentContainer = $($self._rootContainer);
                if (parentNode !== null) {
                    $parentContainer = $self._nodeContainer($(parentNode));
                }
                $parentContainer.append($node);

                $node.show();
                $self._updateProfile($self._currentProfile, parentNode);
                $self._countNode($node);
                $dialog.remove();
                $self._updateNodeInformation();
                $self.refresh();
            };



            var updateNode = function($dialog) {
                $('#astrolabe-add-node-label-error').html('');
                $('#astrolabe-add-node-class-error').html('');
                var nodeprop = validation();
                if (nodeprop === false) {
                    return;
                }
                $(parentNode).attr('label', nodeprop.label);
                $(parentNode).attr('class-regex', nodeprop.classRegex);
                $(parentNode).find('div.nodeWrapper').first().find('div.toolTipWrapper').attr('data-original-title',nodeprop.classRegex);
                $(parentNode).find('div.nodeWrapper').first().find('div.nodeHeader').find('span.nodeLabel').text(nodeprop.label);
                $self._updateProfile($self._currentProfile, parentNode);
                $dialog.remove();
                $self.refresh();
            };

            var btns = {};

            btns['Cancel'] = function() {
                $(this).remove();
                unbindBeforeUnload();
            };

            btns[operation] = function() {

                if (operation == 'Update') {
                    updateNode($(this));
                }else {
                    addNode($(this));
                }
                unbindBeforeUnload();
            };

            let title = operation == 'Update' ? 'Edit sub-category' : 'Add new sub-category';
            var $dialog = $('<div>')
            .load($self.options.baseUrl + '/widget/astrolabeAddNodeDialog/', function() {
                processPageBeforeLeave();
                $('#astrolabe-add-node-label').focus();
                if (operation == 'Update') {
                    $(this).find('#astrolabe-add-node-label').val($(parentNode).attr('label'));
                    $(this).find('#astrolabe-add-node-class').val($(parentNode).attr('class-regex'));
                }
            }).dialog({
                autoOpen: false,
                title: title,
                width: 550,
                buttons: btns,
                draggable: false,
                modal: true,
                resizable: false,
                close:function(event,ui){  //strongly need to clear out the cache.
                    $(this).remove();
                },
                open:function (event) {
                    $('.ui-dialog-buttonpane').find('button:contains("Cancel")').addClass('btn btn-large');
                    $('.ui-dialog-buttonpane').find('button:contains("Add")').addClass('btn btn-primary btn-large');
                    $('.ui-dialog-buttonpane').find('button:contains("Update")').addClass('btn btn-primary btn-large');
                }

            });

            $dialog.keypress(function(event) {
                if (event.keyCode == $.ui.keyCode.ENTER) {
                    event.preventDefault();
                    btns[operation].apply($dialog);
                }
            });

            return $dialog;
        },

        _createHost: function(key, name) {
            // done for performance reason
            var li = '<li class="host" hostkey="' + key + '" hostname="' + name + '">'+
                     '<span class="hostLabel">' + name + '</span>' +
                    '</li>';
            return li;
        },
        _createContainer: function(nodeDescriptionList, isRemovable) {
            var $self = this;
            var $container = $('<ul>');
            $container.addClass('sub-container');

            if (nodeDescriptionList !== undefined &&
                nodeDescriptionList !== null &&
                nodeDescriptionList.length > 0) {

                $.each(nodeDescriptionList, function() {
                    var $node = $self._createNode(this.label, this.classRegex, this.children, this.isRemovable == undefined ? true : this.isRemovable , this.superNode == undefined ? false : this.superNode , this.excludes);
                    $container.append($node);
                });
            }

            return $container;
        },

        _nodeContainer: function($node) {
            return $node.children('ul');
        },

        _subNodes: function(node) {
            var self = this;

            return self._nodeContainer(node).children('li.node');
        },

        _subHosts: function(node) {
            var self = this;

            return self._nodeContainer(node).children('li.host');
        },

        _parentNode: function($node) {
            var $parent = $node.parent().parent();
            if ($parent.hasClass('node')) {
                return $parent;
            }
            else {
                return null;
            }
        },

        _nodeLabel: function($node) {
            return $node.attr('label');
        },

        _nodeClass: function(node) {
            return node.attr('class-regex');
        },

        _excludesClass: function (node) {
            return node.attr('excludes-regex');
        },

        _nodeLabels: function($node) {
            var $self = this;

            var labels = [$self._nodeLabel($node)];

            for ($node = $self._parentNode($node); $node != null; $node = $self._parentNode($node)) {
                labels.push($self._nodeLabel($node));
            }

            return labels;
        },

        _nodeIncludes: function($node) {
            var $self = this;

            var includes = [$self._nodeClass($node)];

            for ($node = $self._parentNode($node); $node != null; $node = $self._parentNode($node)) {
                includes.unshift($self._nodeClass($node));
            }


            return includes.slice(1);
        },

        _nodeExcludes: function($node) {
            var $self = this;

            var excludes = [];
            $self._excludesClass($node) != undefined ? excludes.unshift($self._excludesClass($node)) : false;
            $.each($self._subNodes($node), function() {
                // do not include hosts without category into exclude data of All hosts node
                if (($self._nodeClass($(this)) != '') && ($(this).attr('label') !== $self.options.noCategoryLabel)) {
                    excludes.unshift($self._nodeClass($(this)))
                }
            });

            return excludes;
        },

        _loadNode: function(node, selectAfterLoad) {
            var self = this;

            self._subHosts(node).remove();

            var includes = self._nodeIncludes(node);
            var excludes = self._nodeExcludes(node).join('|');

            // Do not load other hosts in root (All hosts) category
            // because the same category was already introduced and it causes issue if we load them
            // at the same time.
            if(node.parent().hasClass('rootContainer') == true && node.find('.sub-container li').length > 0) {
                var d = new $.Deferred();
                d.resolve();
                common.globalSpinner.hide();
                return d;
            }else {
                return self.initParentNode(node, includes, excludes, selectAfterLoad);
            }
        },

        initParentNode: function($node, includes, excludes, selectAfterLoad) {
            var $self = this;
            var container = $self._nodeContainer($node);
            container
                .attr('data-url', $self._requestUrls.hosts($self, includes, excludes))
                .attr('data-page', 1)
                .attr('data-includes', includes)
                .attr('data-excludes', excludes);

            return $self.loadHosts(container, selectAfterLoad, $node);
        },
        loadHosts: function (container, selectAfterLoad, $node) {
            var $self = this;
            var d = new $.Deferred();
            container.attr('data-loading', 1);
            $(container).append('<li class="loading-element host">loading new hosts....</li>');
            $.post(container.attr('data-url'),
                {
                    page: container.attr('data-page'),
                    count: $self.options.defaultPerPage,
                    includes: container.attr('data-includes'),
                    excludes: container.attr('data-excludes'),
                },
                function (hostDescriptionList) {
                    if (hostDescriptionList !== null) {

                        var itemArray = [];
                        $.each(hostDescriptionList, function (index, host) {
                            var hostItem = $self._createHost(host.id,
                                host.hostname);
                            itemArray.push(hostItem);
                        });

                        $(container).append(itemArray.join(' '));
                        container.attr('data-loading', 0);
                        $('.loading-element').remove();
                    }

                    if (selectAfterLoad === true) {
                        $self._onClickNodeLabel($self, $node, null);

                    }
                    d.resolve();
                }, "json").done(function () {
                common.globalSpinner.hide();
            }).fail(function (jqXHR, textStatus, errorThrown) {
                $self._displayFailure(jqXHR, textStatus, errorThrown);
                d.reject();
            });
            return d;
        },

        _loadProfileList: function() {
            var self = this;
            common.globalSpinner.show();
            var requestUrl = self.options.baseUrl + '/astrolabe/profile/';

            $.getJSON(requestUrl, function(profileList) {

                self._profilesCombo.combobox('clear');
                $.each(profileList, function(index, value) {
                    self._profilesCombo.combobox('addItem', value);
                });

                //$.cookie('profileToLoad') is null  by default.
                if(!$.cookie('profileToLoad')){
                    var osId = self._profilesCombo.combobox('getItemId','OS');
                    self._profilesCombo.combobox('selectItem',osId);
                }else{
                    self._profilesCombo.combobox('selectItem',$.cookie('profileToLoad'));
                }

            });
        },

        _serializeContainer: function($container) {
            var self = this;

            return $.map($container.children('.node'), function(node) {
                var $node = $(node);

                return nodeDescription = {
                    label: $node.attr('label'),
                    classRegex: $node.attr('class-regex'),
                    children: self._serializeContainer($node.children('.sub-container'))
                };
            });
        },

        _profileUrl: function(profileId,sharedTree,sharedFrom) {
            var self = this;
            var urlParams = (sharedTree) ? '/1':'/0';
            urlParams += sharedFrom ? '/'+sharedFrom:'';

            return self.options.baseUrl + '/astrolabe/profile/' + profileId+urlParams+'/'+Math.random();
        },

        _saveProfile: function(profileId,refreshNode,nodeList,targetItem,sharedPermission,global) {
            var $self = this;
            var nodeDescriptionList= nodeList || [];
            var target = targetItem || null;
            var sharedPermission = sharedPermission || [];
            var global = global || false;
            //if a clone of currently selected tree profile is to be created then remove the condition.
            if(refreshNode !== null){
                nodeDescriptionList = $self._serializeContainer($self._nodeContainer($self._superNode));
            }

            var putData = {
                'sharedPermission':sharedPermission,
                'global':global,
                'nodeDescription':nodeDescriptionList
            };

            if (profileId !== null && profileId !== undefined) {
                $.ajax({
                    type: 'PUT',
                    url: $self._profileUrl(profileId),
                    contentType: 'application/json',
                    data: JSON.stringify(putData),
                    dataType:'JSON',
                    success: function(data) {

                        if (refreshNode !== null) {
                            $self._loadNode($(refreshNode), false);
                        } else {
                            $self._loadProfile(data.id);
                            $self._profilesCombo.combobox('updateSelectedId', data.id);
                            var path = $self.getPathForTreeExpansion();
                            $self._expandCurrentContext(path);
                        }
                    }
                });
            }
            else {
                if (refreshNode !== null) {
                    $self._loadNode($(refreshNode), false);
                }
            }
        },

        _updateProfile: function(profileId,refreshNode) {

            var $self = this;
            var  nodeDescriptionList = $self._serializeContainer($self._nodeContainer($self._superNode));
            //remove "hosts without category" to avoid saving this category into database
            nodeDescriptionList.forEach(function (item, index) {
               if(item.label === $self.options.noCategoryLabel){
                   nodeDescriptionList.splice(index,1)
               }
            })

            if (profileId !== null && profileId !== undefined) {

                $.ajax({
                    type: 'POST',
                    url: $self._profileUrl(profileId),
                    data: {
                        'nodeData':JSON.stringify(nodeDescriptionList)
                    },
                    dataType:'JSON',
                    success: function(data) {
                        if (refreshNode !== null) {
                            $self._loadNode($(refreshNode), false);
                        }else{
                            $self._loadProfile(profileId);
                        }
                    }
                });
            }
            else {
                if (refreshNode !== null) {
                    $self._loadNode($(refreshNode), false);
                }
            }
        },

        _deleteProfile: function(profileId) {
            var $self = this;

            $.ajax({
                type: 'DELETE',
                url: $self._profileUrl(profileId)
            });

            if ($self._currentProfile === profileId) {
                $self._rootContainer.children().remove();
            }
        },

        _loadProfile: function(profileId,defaultProfile,sharedTree,sharedFrom) {
            var $self = this;
            var d = new $.Deferred();

            $self._currentProfile = profileId;

            //save the profile to be loaded when user switches the page,
            $.cookie('profileToLoad',profileId);
            $self._rootContainer.children().remove();

            if ($self._currentProfile !== null) {
                $.ajax({
                    type: 'GET',
                    url: $self._profileUrl(profileId,sharedTree,sharedFrom),
                    dataType:'JSON',
                    cache: false,
                    success: function(nodeDescriptionList) {
                        $self._createSuperNode(nodeDescriptionList, defaultProfile);
                        $self._recount().then(function() {
                            d.resolve();
                            var lastElement = $self._rootContainer.find('.node').last();
                            $self._countNode(lastElement).then(function () {
                                if(lastElement.attr('count') > 0){
                                    lastElement.toggle();
                                }
                            });
                        });

                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        $self._profilesCombo.combobox('selectItem', null);
                        d.resolve();
                    }
                });
            }
            else {
                $self._createSuperNode(null, true); //[{"label":"policy_hub",classRegex:"am_policy_hub","children":[]}] for default policynode
                $self._recount().then(function() {
                    d.resolve();
                });
            }
            return d.promise();
        },

        _recount: function() {
            var $self = this;
            var d = new $.Deferred();
            var $node = $self._superNode;
            var $ids = [];
            $self._rootContainer.find('.node').each(function(index, value) {
                var $node = $(value);
                $ids.push($node.attr('id'));
            });
            $self._updateCount($ids).then(function(){
                d.resolve();
            });
            return d.promise();
        },

        _updateNodeInformation: function() {
            var $self = this;

            $self._rootContainer.find('.node').each(function(index, value) {
                var $node = $(value);
                $node.attr('data-includes',$self._nodeIncludes($node));
                $node.attr('data-excludes',$self._nodeExcludes($node));
            });

        },

        // get the ids and data-includes to get count at once
        _updateCount:function($ids) {
            var $self = this;
            var deferred = $.Deferred();
            var length = $ids.length || 0;
            // don't send request to get last category count
            length = length == 1 ? 1 : length - 1;
            var postData = [];
            var nodeStructure = [];

            for (var i = 0; i<length;i++) {
                var id = $ids[i];
                var includes = $('li#'+id).attr('data-includes');
                var excludes = $('li#' + id).attr('data-excludes');
                nodeStructure.push({
                    'id':id,
                    'includes': includes,
                    'excludes': excludes
                });
            }
            postData.push(nodeStructure);
            if (postData.length > 0) {
                $.ajax({
                    type: 'POST',
                    url: $self._requestUrls.updateCount($self),
                    data: {
                        'data':postData
                    },
                    dataType:'JSON',
                    success: function(data) {
                        $self._countNodeBatch(data);
                        deferred.resolve();

                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        $self._displayFailure(jqXHR, textStatus, errorThrown);
                    }
                });
            }
            return deferred.promise();
        },

        _countNode: function($node) {
            var deferred = $.Deferred();
            var $self = this;
            var includes = $self._nodeIncludes($node);
            var excludes = $self._nodeExcludes($node);
            $.getJSON($self._requestUrls.hostCount($self, includes, excludes), function (count) {
                $node.attr('count', count);
                $node.find('div.nodeWrapper').first().find('div.nodeHeader').find('span.hostCountLabel').html('(' + count + ')');
                deferred.resolve();
            }).fail(function(jqXHR, textStatus, errorThrown){
                $self._displayFailure(jqXHR, textStatus, errorThrown);
            });
            return deferred.promise();
        },

        _countNodeBatch: function($data) {
            var $self = this;

            for (var key in $data) {
                var id  = $data[key].id;
                var count = $data[key].count;
                var $node = $('#'+id);
                $node.attr('count', count);
                $node.find('div.nodeWrapper').first().find('div.nodeHeader').find('span.hostCountLabel').html('(' + count + ')');
            }
        },




        _createSuperNode: function(nodeDescriptionList,defaultProfile)
        {
            var $self = this;
            $self._rootContainer.children().remove();
            var isRemovable = true;
            if (defaultProfile !== undefined && defaultProfile === true) {
                isRemovable = false;
            }

            if (nodeDescriptionList != null) {
                var excludes = $self._getAllIncludes(nodeDescriptionList);
                nodeDescriptionList.push({
                    label: $self.options.noCategoryLabel,
                    classRegex: ".*",
                    children: [],
                    isRemovable: false,
                    superNode: true,
                    excludes: excludes.join('|')
                });
            }

            $self._superNode = $self._createNode('All hosts',
                '.*', nodeDescriptionList, isRemovable,true);

            $self._rootContainer.append($self._superNode);

            $self._updateNodeInformation();
            return $self._superNode;
        },

        _getAllIncludes: function (nodeDescriptionList) {
            var $self = this;
            var classes = [];
            if (nodeDescriptionList != null) {
                nodeDescriptionList.forEach(function (item) {
                    classes.push(item.classRegex);
                    if (item.children != undefined && item.children.length > 0) {
                        $self._getAllIncludes(item.children);
                    }
                });
            }
            return classes;
        },

        _requestUrls: {

            hosts: function(self) {
                var uniqueTimeStamp=new Date();
                var url = self.options.baseUrl + '/astrolabe/host?nocache=' + uniqueTimeStamp.getTime();
                return url;
            },

            hostCount: function(self, includes, excludes) {
                var url = self.options.baseUrl + '/host/count?';

                if (includes.length > 0) {
                    url = url + 'includes=' + encodeURIComponent(includes);
                }

                if (excludes.length > 0) {
                    url = url + '&excludes=' + encodeURIComponent(excludes);
                }

                return url;
            },

            updateCount: function (self){
                return self.options.baseUrl + '/host/updateCount';
            }
        },

        _displayFailure:function(jqXHR,textStatus, errorThrown){

            var serverMsg="",
            $self=this;
            if (jqXHR.status == 403 ||jqXHR.status == 401 || jqXHR.responseText == $self.options.accessDeniedResponse) {
                serverMsg = '<strong>Access denied</strong> <br /> Your role does not have sufficient privileges. Please contact your system administrator.';
            } else if(jqXHR.status = 500) {
                serverMsg = errorThrown;
            }
            $self._scrollable_list.html("<div class='alert alert-error' style='padding: 1em;'><p>" + ' ' + serverMsg + '</p></div>');
            common.globalSpinner.hide();
        },

        _confirmationDialog:function(title,message,action){
            var $self=this;
            var $confirmation=$( "<div>" ).html(message).dialog({
                title: title,
                resizable: false,
                modal: true,
                buttons: {
                    Cancel: function() {
                        $(this).remove();
                    },
                    "Remove": function() {
                        action();
                        $(this).remove();
                    }
                },
                open: function(event, ui) {
                    $(this).parent().find(":button:contains('Cancel')").addClass('btn btn-large');
                    $(this).parent().find(":button:contains('Remove')").addClass('btn btn-primary btn-large btn-danger').focus();
                },
                close:function(event,ui){  //strongly need to clear out the cache.
                    $(this).remove();
                }
            });
            $('.ui-icon-closethick').html('×');
            return $confirmation;
        },

        hostsLazyLoadingWatcher: function () {
            var $self = this;
            $('#astrolabe').scroll(function () {
                var nodeElements = $self.isElementInView($('ul.sub-container'));
                if(nodeElements != undefined && nodeElements.length > 0){
                    $(nodeElements).each(function (index, nodeElement) {
                        var maxHostCount = $self.getMaxHostCount(nodeElement);
                        var maxPage = parseInt(maxHostCount / $self.options.defaultPerPage +  (maxHostCount%$self.options.defaultPerPage == 0 ? 0 : 1));
                        var nextPage = parseInt(nodeElement.attr('data-page')) + 1;
                        if(nextPage <= maxPage){
                            nodeElement.attr('data-page', nextPage);
                            $self.loadHosts(nodeElement, false, null);
                        }
                    })
                }
            });

        },

        getMaxHostCount: function (nodeElement) {
            var parent = nodeElement.closest('li.node');

            if(parent.find('li.node').length > 0){
               var allHostsCount = parent.attr('count');
               var categorizedHostCount = 0;

               $(parent.find('li.node')).each(function (i, v) {
                   categorizedHostCount += parseInt($(v).attr('count'));
               });

               return allHostsCount - categorizedHostCount;
            } else{
                return parent.attr('count');
            }

        },

        isElementInView: function (elements) {
            var pageTop = $('#astrolabe').offset().top;
            var pageBottom = pageTop + $('#astrolabe').height();
            var result = [];
            elements.each(function( index, element ) {

                if($(element).css('display') == 'none' || $(element).attr('data-loading')  == 1){
                    return true;
                }

                var elementTop = $(element).offset().top;
                var elementBottom = elementTop + $(element).height() - 100; // add 100 to do loading before user get end of list

                if ((elementBottom <= pageBottom) && (elementBottom >= pageTop)){
                    result.push($(element));
                }
            });
            return result;
            },


        destroy: function() {
            $.Widget.prototype.destroy.call(this);
        }
    });

    $.extend($.ui.astrolabe, {
        instances: []
    });

})(jQuery);