<?php

class CF_ComplianceScore
{
    private $report_id;
    private $username;
    private $score;
    private $update_ts;
    private $fail_checks;
    private $total;

    function __construct($params = [])
    {
        $this->report_id = isset($params['report_id']) ? $params['report_id'] : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->score = isset($params['score']) ? $params['score'] : null;
        $this->update_ts = isset($params['update_ts']) ? $params['update_ts'] : 'now()';
        $this->fail_checks = isset($params['fail_checks']) ? $params['fail_checks'] : null;
        $this->total = isset($params['total']) ? $params['total'] : null;
    }

    public function getReportId()
    {
        return $this->report_id;
    }

    public function setReportId($report_id)
    {
        $this->report_id = $report_id;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function setUsername($username)
    {
        $this->username = $username;
    }

    public function getScore()
    {
        return $this->score;
    }

    public function setScore($score)
    {
        $this->score = $score;
    }

    public function getUpdateTs()
    {
        return $this->update_ts;
    }

    public function setUpdateTs($update_ts)
    {
        $this->update_ts = $update_ts;
    }

    public function getFailChecks()
    {
        return $this->fail_checks;
    }

    public function setFailChecks($fail_checks)
    {
        $this->fail_checks = $fail_checks;
    }

    public function getTotal()
    {
        return $this->total;
    }

    public function setTotal($fail_checks)
    {
        $this->fail_checks = $total;
    }

    public function toArray()
    {
        return [
            'report_id' => $this->getReportId(),
            'username' => $this->getUsername(),
            'score' => $this->getScore(),
            'update_ts' => $this->getUpdateTs(),
            'fail_checks' => $this->getFailChecks(),
            'total' => $this->getTotal(),
        ];
    }

    public function __toString()
    {
        return json_encode($this->toArray());
    }

}
