<?php
/*
 * this partial is used in save search modal and create schedule for new report ?>
 */
?>
<div class="control-group required">
    <div class="control-label">
        <label for="scheduleName">Report title</label>
    </div>
    <div class="controls">
        <input type="text"
               ng-model="savedSearchName.input"
               focus-me="{{savedSearchName}}"
               name="savedSearchName" maxlength="150"
               ng-pattern="/^[A-Za-z0-9-_%,.<>()=\s]+$/"
               maxlength="100"
               required>
        </input>
        <div class="error" ng-show="<?= htmlspecialchars($formName) ?>.savedSearchName.$dirty && <?= htmlspecialchars($formName) ?>.savedSearchName.$invalid">
            <span ng-show="<?= htmlspecialchars($formName) ?>.savedSearchName.$error.required">The query title is missing.</span>
            <span ng-show="<?= htmlspecialchars($formName) ?>.savedSearchName.$error.pattern">Please use only letters, numbers, space and -%,._&lt;&rt;>()=.</span>
        </div>
    </div>
</div>
<div class="control-group required">
    <div class="control-label">
        <label for="savedSearchCategory" >Report category</label>
    </div>
    <div class="controls">
         <select ng-if="savedSearchCategory.input!='inventory'&&savedSearchCategory.input!='changes'"
             ng-init="savedSearchCategory.input=savedSearchCategory.input || 'uncategorized'"
             ng-model="savedSearchCategory.input"
             ng-options="f.value as f.label for f in reportCategories | filter:f.value='!inventory' |  filter:f.value='!changes'"
             name="savedSearchCategory"
             ng-disabled="categorySelectDisabled"
             class=""
             required>
         </select>
        <p class="level-text" ng-if="savedSearchCategory.input=='inventory'">Inventory</p>
        <p class="level-text" ng-if="savedSearchCategory.input=='changes'">Changes</p>
        <div class="error" ng-show="<?= htmlspecialchars($formName) ?>.savedSearchType.$dirty && <?= htmlspecialchars($formName) ?>.savedSearchType.$invalid">
            <span ng-show="<?= htmlspecialchars($formName) ?>.savedSearchName.$error.required">The query category is missing.</span>
        </div>
    </div>
</div>
<div class="control-group" ng-show="!isObjEmpty(roles)">
    <div class="control-label">
        <label for="">Share report with these user roles</label>
    </div>
    <div class="controls">
        <div style="padding-top:5px" table-list tabledata="roles" selectedtables="reportRoles" parentfunc="roles_disablePublicReport()"></div>
    </div>
</div>
<div class="control-group" ng-show="is_admin==true">
    <div class="control-label">
        <label>Set as public</label>
    </div>
    <div class="controls">
        <label style="margin-top:3px">
            <input type="checkbox" id="is_public" ng-model="is_public.input" ng-change="publicReport_disableRoles()" name="is_public"></input>
        </label>
    </div>
</div>