<?php

if (!function_exists('yaml_emit')) {
    function yaml_emit(array $data, $level = 0, $content = '')
    {
        $formatResult = function ($key, $value, $level) {
            $result = str_repeat(' ', $level * 2);
            switch (gettype($key)) {
                case 'string':
                    $result .= '"' .$key. '"' . ': '. $value;
                    break;
                case 'integer':
                    $result .= $value ? '- "' .$value. '"' : '';
                    break;
                default:
                    $result .= '"' .$value. '"' . ':';
                    break;
            }
            return empty(trim($result)) ? '' : $result . PHP_EOL;
        };

        foreach ($data as $key => $item) {

            if (is_array($item)) {
                $formattedContent = $formatResult($key, '', $level);
                $content .= $formattedContent;
                $content = yaml_emit($item, ($formattedContent ? $level + 1 : $level), $content);
            } else {
                $content .= $formatResult($key, $item, $level);
            }
        }
        return $content;
    }
}
