
<div class="pageTitle">
    <h1>
        <span>Reports</span>
        <span class="pull-right">
            <i rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help icon-question-sign" data-key="sql-reports" data-title="SQL reports" data data-placement='left' title="Click for help"> </i>
        </span>
    </h1>
</div>

<?php $this->load->view('/partials/_reports-speeddial'); ?>

<div class="row-fluid sql-result-table-wrapper">

    <div class="reportTabSelector">
        <a  ng-repeat="(id, label) in tabs.options" ng-class="{active: id == tabs.selected}" ng-click="tabs.selected=id">{{ label }}</a>
    </div>

    <div class="categorySelector">
        <button class="btn dropdown-toggle">
            {{ selectedCategoryPlaceholder }}
            <span class="caret pull-right"></span>
        </button>
        <ul class="dropdown-menu">
            <li ng-repeat="category in reportCategories">
                <div class="checkbox">
                    <label>
                        <input type="checkbox"
                               ng-click="filterCategories(category.value)"
                               ng-checked="isSelectedCategory(category.value)"
                        />
                        {{category.label}}
                    </label>
                </div>
            </li>
        </ul>
    </div>

    <div class="row-fluid">

        <div class="span10 max-table">

            <?php $this->load->view('/partials/_notification'); ?>
            <h3 class="center margin-top-large" ng-show="!savedReports.length && reports_loaded">
               No reports found
            </h3>
            <div ng-show="savedReports.length">
                <table class="table table-horizontal listReports_SE margin-top float-left">
                    <thead>
                        <tr>
                            <th class="sort-head" ng-click="sortReorder('username_0', $event)">Author
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['username_0'].sort<0,'icon-chevron-down':VIEW.tablehead['username_0'].sort>0}"></i>
                            </th>
                            <th>Schedules</th>
                            <th class="sort-head fill" ng-click="sortReorder('label_1', $event)">Name
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['label_1'].sort<0,'icon-chevron-down':VIEW.tablehead['label_1'].sort>0}"></i>
                            </th>
                             <th class="sort-head" ng-click="sortReorder('reportCategory_2', $event)">Category
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['reportCategory_2'].sort<0,'icon-chevron-down':VIEW.tablehead['reportCategory_2'].sort>0}"></i>
                            </th>
                            <th class="actions right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="(rowid, row) in savedReports" testforlast="">
                            <td ng-bind-html="getUserName(row) | safe_html"></td>
                            <?php
                            // for admin - show own and total
                            // for user show count if it has schedules
                            ?>
                            <td><span ng-show="row.hasSchedules == 1"><i class="icon-time no-hover"></i></span><span ng-show="row.showScheduleStatistic==1">(<span style="color: green">{{row.ownSchedules}}</span>/{{row.totalSchedules}})</span><span ng-show="row.showScheduleStatistic== false && row.hasSchedules==1 && row.ownSchedules>0">{{row.ownSchedules}}</span></td>

                            <td class="fill">
                                <i ng-if="!favouriteReports.includes(row.id)" ng-click="addFavourite(row.id)" title="Add to favourites" class="bi bi-star"></i>
                                <i ng-if="favouriteReports.includes(row.id)" ng-click="removeFavourite(row.id)"  title="Remove from favourites" class="bi bi-star-fill"></i>
                                <a ng-if="row.reportCategory != 'inventory' && row.reportCategory != 'changes' && row.reportCategory != 'compliance_report'" ng-href="report/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                                <a ng-if="row.reportCategory == 'inventory'" ng-href="inventory/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                                <a ng-if="row.reportCategory == 'changes'" ng-href="changes/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                                <a ng-if="row.reportCategory == 'compliance_report'" ng-href="compliance/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                            </td>
                            <td class="no-wrap">{{row.reportCategory | convertReportCategories}}</td>
                            <td class="actions no-wrap right">
                                <a ng-if="row.reportCategory != 'inventory' && row.reportCategory != 'changes' && row.reportCategory != 'compliance_report'" ng-show="row.readonly!=1 && row.can_edit == 1" ng-href="custom/edit/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()" href="javascript:void(0)">edit</a>
                                <a ng-if="row.reportCategory == 'inventory'" ng-show="row.readonly!=1 && row.can_edit == 1" ng-href="inventory/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()" href="javascript:void(0)">edit</a>
                                <a ng-if="row.reportCategory == 'changes'" ng-show="row.readonly!=1 && row.can_edit == 1" ng-href="changes/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()" href="javascript:void(0)">edit</a>
                                <a ng-if="row.reportCategory == 'compliance_report'" ng-show="row.readonly!=1 && row.can_edit == 1" ng-href="compliance/edit/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()" href="javascript:void(0)">edit</a>

                                <a ng-show="row.readonly!=1 && row.can_delete==1"   ng-click="cleanStoredScope(); deleteConfirm(row.id)" href="javascript:void(0)">remove</a>
                                <a ng-show="(row.is_own == 1 || row.is_subscribed==1) && row.reportCategory != 'changes'" ng-href="report/schedule/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">schedule</a>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <?php $this->load->view('/partials/_pagination'); ?>
            </div>
        </div>
     </div>
</div>



<div class="clearfix"></div>

<?php
    // get current logged in user
    $userdata = $this->ion_auth->get_user($this->session->userdata('username'));
    $username = $this->session->userdata('username');
?>

<script type="text/javascript">
    function addUserLabelClass() {
        //if current logged in user, match the username to label tag to change style
        var username = '<?= htmlspecialchars($username) ?>';
        if (username) $('.'+username).addClass('label-warning');
    }

</script>

<script type="text/ng-template" id="deleteConfirm.html">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()"><i class="bi bi-x"></i></button>
        <h2>Remove report</h2>
    </div>
    <div class="modal-body">
        <p>
            Are you sure you want to permanently remove this report?
        </p>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large" data-dismiss="modal" ng-click="close()">Cancel</button>
        <button id="remove_report" class="btn btn-large btn-primary btn-danger" data-dismiss="modal" ng-click="deleteReport(selectedReport)" >Remove</button>
    </div>
</script>



