<?php

/**
 * Class FlashDataHook
 *
 * CI doesn't clear flash data on PHP 8, this hook mark flash data as temp with TTL 1sec.
 * after the final rendered page is sent to the browser,
 */
class FlashDataHook
{
    public function clear()
    {
        if (CLI === true) {
            return false;
        }

        $ci = &get_instance();
        $flashData = $ci->session->flashdata();

        if (!empty($flashData) && is_array($flashData)) {
            foreach (array_keys($flashData) as $key) {
                $ci->session->mark_as_temp($key, $ttl = 1);
            }
        }
    }
}
