import config from '@northern.tech/prettier-config/react.js';

export default {
  ...config,
  plugins: [
    ...(config.plugins || []),
    '@prettier/plugin-php'
  ],
  phpVersion: '8.4',
  overrides: [
    ...(config.overrides || []),
    {
      files: ['*.php', '!**/views/**/*.php'],
      options: {
        tabWidth: 4,
        printWidth: 120,
        singleQuote: true,
        trailingCommaPHP: true,
        braceStyle: 'psr-2'
      }
    }
  ]
};
