<?php
class Cf_Exceptions extends CI_Exceptions
{
    public function show_error($heading, $message = '', $template = 'error_general', $status_code = 500)
    {
        $loaded = defined('CFE_MP_BOOTSTRAP'); // check for controller loaded

        if (is_array($message)) {
            $message = implode(',', $message);
        }
        if (ENVIRONMENT === 'development' && $status_code != '404') {
            // get backstrace for debugging
            $e = new Exception();
            $backTrace = '<pre>' . $e->getTraceAsString() . '</pre>';
            $message = $message . "\n" . $backTrace;
        }
        if ($status_code !== 404) {
            log_message('error', $message);
        }
        if (!CLI) {
            if ($template === 'error_general' && $loaded) {
                // This needs authentication module and base controller to be loaded
                echo modules::run('error/error_default', $heading, $message);
            } else {
                echo parent::show_error($heading, $message, $template, $status_code);
            }
        } else {
            echo 'Error:: ' . $heading . "\n" . $message;
        }
    }
}
