<?php
include_once __DIR__ . '/rules_report/autoload.php';
class Assets_model extends Cf_Model
{
    public function getSoftwareInstalledParams($hostkey)
    {
        return [
            'fields' => [
                'Software.SoftwareArchitecture' => [
                    'name' => 'SoftwareArchitecture',
                    'label' => 'Software architecture',
                    'inputType' => 'text',
                    'table' => 'Software',
                    'sqlField' => 'Software.SoftwareArchitecture',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
                'Software.SoftwareName' => [
                    'name' => 'SoftwareName',
                    'label' => 'Software name',
                    'inputType' => 'text',
                    'table' => 'Software',
                    'sqlField' => 'Software.SoftwareName',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
                'Software.SoftwareVersion' => [
                    'name' => 'SoftwareVersion',
                    'label' => 'Software version',
                    'inputType' => 'text',
                    'table' => 'Software',
                    'sqlField' => 'Software.SoftwareVersion',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
            ],
            'filters' => [
                [
                    'name' => 'HostKey',
                    'label' => 'Host key',
                    'inputType' => 'text',
                    'table' => 'Software',
                    'sqlField' => 'Software.HostKey',
                    'dataType' => 'string',
                    'isSelected' => false,
                    'logical' => 'AND',
                    'comparison' => '=',
                    '$$hashKey' => '098',
                    'value' => $hostkey,
                ],
            ],
            'groupby' => [],
            'orderby' => [],
            'limit' => '',
            'SQLSTRING' =>
                'SELECT Software.SoftwareArchitecture AS "Software architecture", Software.SoftwareName AS "Software name", Software.SoftwareVersion AS "Software version", Software.ChangeTimeStamp AS "Discovered at (UTC)"
                            FROM Software
                            WHERE  Software.HostKey = \'' .
                $this->db->escape_str($hostkey) .
                '\'',
        ];
    }

    public function getAvailableSoftwareParams($hostkey)
    {
        return [
            'fields' => [
                'SoftwareUpdates.PatchName' => [
                    'name' => 'PatchName',
                    'label' => 'Update name',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.PatchName',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
                'SoftwareUpdates.PatchVersion' => [
                    'name' => 'PatchVersion',
                    'label' => 'Update version',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.PatchVersion',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
                'SoftwareUpdates.PatchArchitecture' => [
                    'name' => 'PatchArchitecture',
                    'label' => 'Architecture',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.PatchArchitecture',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
                'SoftwareUpdates.PatchReportType' => [
                    'name' => 'PatchReportType',
                    'label' => 'Update type',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.PatchReportType',
                    'dataType' => 'string',
                    'isSelected' => true,
                ],
            ],
            'filters' => [
                [
                    'name' => 'PatchReportType',
                    'label' => 'Patch-report type',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.PatchReportType',
                    'dataType' => 'string',
                    'isSelected' => true,
                    'logical' => 'AND',
                    'comparison' => '=',
                    '$$hashKey' => '05N',
                    'value' => 'AVAILABLE',
                ],
                [
                    'name' => 'HostKey',
                    'label' => 'Host key',
                    'inputType' => 'text',
                    'table' => 'SoftwareUpdates',
                    'sqlField' => 'SoftwareUpdates.HostKey',
                    'dataType' => 'string',
                    'isSelected' => false,
                    'logical' => 'AND',
                    'comparison' => '=',
                    '$$hashKey' => '05R',
                    'value' => $hostkey,
                ],
            ],
            'groupby' => [],
            'orderby' => [],
            'limit' => '',
            'SQLSTRING' =>
                'SELECT SoftwareUpdates.PatchName AS "Software name", SoftwareUpdates.PatchVersion AS "Software version", SoftwareUpdates.PatchArchitecture AS "Software architecture", SoftwareUpdates.ChangeTimeStamp AS "Discovered at (UTC)"
                            FROM SoftwareUpdates
                            WHERE  SoftwareUpdates.PatchReportType = \'AVAILABLE\'
                            AND SoftwareUpdates.HostKey = \'' .
                $hostkey .
                '\'',
            'hostcontexts' => [
                'name' => 'All hosts',
                'includes' => [],
                'isHosts' => false,
            ],
            'excludedHosts' => '',
        ];
    }

    public function getComplianceReportParams($sql, $rule, $type, $report)
    {
        $hostcontexts =
            isset($rule->hostcontexts) && !empty($rule->hostcontexts)
                ? $rule->hostcontexts
                : [
                    'name' => 'All hosts',
                    'includes' => [],
                    'isHosts' => false,
                ];

        $class = ucfirst($rule->type) . '_rule_report';

        // to show passing hosts we need to invert $conditionMustBeMet value
        $conditionMustBeMet =
            BaseRuleReport::PASSING_TYPE === $type ? !$rule->conditionMustBeMet : $rule->conditionMustBeMet;

        /**
         * @var $reportModel BaseRuleReport
         */
        $reportModel = class_exists($class)
            ? new $class($conditionMustBeMet, $type)
            : new DefaultRuleReport($conditionMustBeMet, $type);
        $reportSQL = $reportModel->getReportSql($sql, $rule);
        $breadCrumbs = [
            'Reports' => '/reports',
            'Compliance' => '/reports/compliance',
        ];

        if ($report !== null) {
            $breadCrumbs[$report->label] = '/reports/compliance/run/' . intval($report->id);
        }

        $breadCrumbs[$rule->name . ' | ' . $type] = '';

        return [
            'SQLSTRING' => $reportSQL,
            'hostcontexts' => $hostcontexts,
            'excludedHosts' => '',
            'highlight' => ['passing' => 'green', 'failing' => 'red'],
            'breadcrumbs' => $breadCrumbs,
            'ruleId' => $rule->id,
            'reportId' => $report->id,
            'type' => $type,
        ];
    }
}
