<?php
require_once APPPATH . 'models/Entities/CF_AuditLogListArguments.php';

class Auditlog_model extends Cf_Model
{
    public const AUDIT_LOGS_API_ENDPOINT = '/audit-log';

    public function list(CF_AuditLogListArguments $arguments)
    {
        try {
            return json_decode(
                $this->getRestClient()->get(self::AUDIT_LOGS_API_ENDPOINT . '?' . $arguments->toGetParameters()),
                associative: true,
            );
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    public function item(int $auditLogId)
    {
        try {
            return json_decode(
                $this->getRestClient()->get(self::AUDIT_LOGS_API_ENDPOINT . '/' . $auditLogId, processBody: false),
                associative: true,
            );
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    public function namesByType(string $type)
    {
        try {
            return json_decode(
                $this->getRestClient()->get(self::AUDIT_LOGS_API_ENDPOINT . '/' . $type . '/names', processBody: false),
                associative: true,
            );
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    public function actors()
    {
        try {
            return json_decode(
                $this->getRestClient()->get(self::AUDIT_LOGS_API_ENDPOINT . '/actors', processBody: false),
                associative: true,
            );
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }
}
