<?php

readonly class CF_AuditLogListArguments
{
    public const DEFAULT_SORT_COLUMN = 'time';
    public const DEFAULT_SORT_DIRECTION = 'desc';
    public const DEFAULT_PER_PAGE = 20;
    public const DEFAULT_PAGE = 1;

    public function __construct(
        public int $per_page = self::DEFAULT_PER_PAGE,
        public int $page = self::DEFAULT_PAGE,
        public string $sort_column = self::DEFAULT_SORT_COLUMN,
        public string $sort = self::DEFAULT_SORT_DIRECTION,
        public ?string $actor_id = null,
        public ?string $object_type = null,
        public ?string $object_name = null,
        public ?string $object_id = null,
        public ?string $action = null,
        public ?int $created_after = null,
        public ?int $created_before = null,
    ) {}

    public static function fromArray(array $data): self
    {
        return new self(
            $data['per_page'] ?? self::DEFAULT_PER_PAGE,
            $data['page'] ?? self::DEFAULT_PAGE,
            $data['sort_column'] ?? self::DEFAULT_SORT_COLUMN,
            $data['sort'] ?? self::DEFAULT_SORT_DIRECTION,
            $data['actor_id'] ?? null,
            $data['object_type'] ?? null,
            $data['object_name'] ?? null,
            $data['object_id'] ?? null,
            $data['action'] ?? null,
            isset($data['created_after']) ? (int) $data['created_after'] : null,
            isset($data['created_before']) ? (int) $data['created_before'] : null,
        );
    }

    public function toGetParameters(): string
    {
        $params = array_filter(
            [
                'actor' => $this->actor_id,
                'object_type' => $this->object_type,
                'object_name' => $this->object_name,
                'object_id' => $this->object_id,
                'action' => $this->action,
                'offset' => ($this->page - 1) * $this->per_page,
                'limit' => $this->per_page,
                'created_after' => $this->created_after,
                'created_before' => $this->created_before,
                'sort_direction' => $this->sort,
                'sort_column' => $this->sort_column,
            ],
            fn($value) => $value !== null,
        );

        return http_build_query($params);
    }
}
