<?php

class CF_License
{
    private $details;
    private $granted;
    private $utilized;
    private $owner;
    private $licenseType;
    private $expires;

    public function __construct(array $data)
    {
        $this->details = isset($data['details']) ? $data['details'] : null;
        $this->granted = isset($data['granted']) ? $data['granted'] : null;
        $this->utilized = isset($data['utilized']) ? $data['utilized'] : null;
        $this->owner = isset($data['owner']) ? $data['owner'] : null;
        $this->licenseType = isset($data['licenseType']) ? $data['licenseType'] : null;
        $this->expires = isset($data['expires']) ? $data['expires'] : null;
    }

    public function toArray()
    {
        return [
            'details' => $this->details,
            'granted' => $this->granted,
            'utilized' => $this->utilized,
            'owner' => $this->owner,
            'licenseType' => $this->licenseType,
            'expires' => $this->expires,
        ];
    }

    /**
     * @return mixed
     */
    public function getUtilized()
    {
        return $this->utilized;
    }

    /**
     * @param mixed $utilized
     */
    public function setUtilized($utilized)
    {
        $this->utilized = $utilized;
    }

    /**
     * @return mixed
     */
    public function getDetails()
    {
        return $this->details;
    }

    /**
     * @param mixed $details
     */
    public function setDetails($details)
    {
        $this->details = $details;
    }

    /**
     * @return mixed
     */
    public function getGranted()
    {
        return $this->granted;
    }

    /**
     * @param mixed $granted
     */
    public function setGranted($granted)
    {
        $this->granted = $granted;
    }

    /**
     * @return mixed
     */
    public function getOwner()
    {
        return $this->owner;
    }

    /**
     * @param mixed $owner
     */
    public function setOwner($owner)
    {
        $this->owner = $owner;
    }

    /**
     * @return mixed
     */
    public function getLicenseType()
    {
        return $this->licenseType;
    }

    /**
     * @param mixed $licenseType
     */
    public function setLicenseType($licenseType)
    {
        $this->licenseType = $licenseType;
    }

    /**
     * @return mixed
     */
    public function getExpires()
    {
        return $this->expires;
    }

    /**
     * @param mixed $expires
     */
    public function setExpires($expires)
    {
        $this->expires = $expires;
    }
}
