<?php
/**
 * Entities for the Tracker
 *
 */

class CF_tracker
{
    public $userName;
    public $trackerName;
    public $reportType;
    public $resource; // can be any promise handle, bundle, class exp etc. but only handle for now
    public $dateTimeStamp;
    public $frequency;
    public $id;

    public function __construct($params = [])
    {
        $this->id = isset($params['_id']) ? $params['_id']->__toString() : null;
        $this->userName = isset($params['userName']) ? $params['userName'] : null;
        $this->resource = isset($params['resource']) ? $params['resource'] : null;
        $this->dateTimeStamp = isset($params['dateTimeStamp']) ? $params['dateTimeStamp'] : null;
        $this->reportType = isset($params['reportType']) ? $params['reportType'] : null;
        $this->frequency = isset($params['frequency']) ? $params['frequency'] : null;
        $this->trackerName = isset($params['trackerName']) ? $params['trackerName'] : null;
    }

    public function getUsername()
    {
        return $this->userName;
    }

    public function getReportType()
    {
        return $this->reportType;
    }

    public function getDateTime()
    {
        return date('Y-m-d H:i:s', $this->dateTimeStamp);
    }

    public function getDateTimeStamp()
    {
        return $this->dateTimeStamp;
    }

    public function getResource()
    {
        return $this->resource;
    }

    public function getFrequency()
    {
        return $this->frequency;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getName()
    {
        return $this->trackerName;
    }
}
