<?php

class LlmConfigModel extends Cf_Model
{
    public const aiSettingsResource = '/ai-settings';

    public function getFirstConfig()
    {
        $response = $this->getRestClient()->get(self::aiSettingsResource);
        $result = json_decode($response, associative: true);
        return $result[0] ?? null;
    }

    public function createConfig($data)
    {
        $response = $this->getRestClient()->post(self::aiSettingsResource, $data);
        return $response;
    }

    public function updateConfig(int $id, array $data)
    {
        $response = $this->getRestClient()->patch(self::aiSettingsResource . "/{$id}", $data);
        return $response;
    }

    public function deleteConfig(int $id)
    {
        $json = $this->getRestClient()->delete(self::aiSettingsResource . "/$id");
        return $json;
    }
}
