<?php
require_once APPPATH . 'modules/dashboard/models/entities/CF_Widget.php';

class widget_model extends Cf_Model
{
    public $widgetsCollectionName = 'dashboard_widgets';
    public $userCollectionName = 'users';

    public $defaultFilter;

    public $allowedActions;

    public function __construct()
    {
        parent::__construct();
    }

    public function savewidget($data, $overwrite, $is_admin)
    {
        if (!is_array($data)) {
            $this->setError('Invalid parameter passed to function');
            return false;
        }

        $id = '';
        $updateAlerts = [];
        $dashboardWidgets = [];

        $filter['username'] = $data['username'];

        if (isset($data['id'])) {
            $id = $data['id'];
            $filter['id'] = intval($data['id']);
            unset($data['id']);
        } else {
            $filter['name'] = $data['name'];
        }

        $this->setDefaultFilter($filter);

        if (array_key_exists('alerts', $data)) {
            if (!empty($data['alerts'])) {
                $updateAlerts = $data['alerts'];
            }

            unset($data['alerts']); // we dont need this now for insert
        }

        if (isset($data['widgets'])) {
            $dashboardWidgets = $data['widgets'];
            unset($data['widgets']); // we dont need this now for insert
        }

        if ($this->validate($data, $overwrite, $is_admin, $dashboardWidgets) === false) {
            $message = $this->getErrors();
            $text = $this->lang->line('dashboard_widget_unable_to_save') . ' ' . $message[0]['text'];
            throw new Exception($text);
        }

        $filter['widgets'] = $dashboardWidgets;

        if (!empty($dashboardWidgets)) {
            $currentItem = $this->get_all_widgets($filter);

            if (!empty($currentItem)) {
                $id = $currentItem[0]->id;
                $owner = $currentItem[0]->getUsername();

                // check  owner. if this widget created by user and get's overwritten by admin, we will try to keep original owner
                // $data['username'] - user who created wizard, in most cases current logged user
                if ($owner !== $data['username']) {
                    $data['username'] = $owner;
                }
            }
        }

        if ($id == '') {
            // not exist - insert it will return inserted item
            $this->db->insert($this->widgetsCollectionName, $data);
            $id = $this->db->insert_id();
        } else {
            // if exist - update, and then select inserted item
            $this->db->where(['id' => $id])->update($this->widgetsCollectionName, $data);
        }

        // get object from DB
        $offset = '';
        $limit = '';
        $order = [];

        $objTmp = $this->get_all_widgets(['id' => $id], $offset, $limit, $order);

        if ($objTmp) {
            $widget = $objTmp[0];

            // TODO:
            // HACK: Update all alerts inside widget and set reference to it
            if (!empty($widget->id)) {
                $this->load->model('alerts_model');

                $data = ['widgetid' => $widget->id, 'widgetName' => $widget->name];

                if ($widget->type == 'alerts' && !empty($updateAlerts)) {
                    $updateAlerts = array_filter(array_map('intval', $updateAlerts)); // remove empty vals

                    foreach ($updateAlerts as $alertId) {
                        $this->alerts_model->updatealertById($alertId, $data);
                    }
                }
            }
            return $widget;
        } else {
            // shouldn't happen
            throw new Exception($this->lang->line('dashboard_widget_unable_to_load'));
        }
    }

    public function validate($data, $overwrite = false, $is_admin = false, $dashboardWidgets = [])
    {
        $valid = true;

        if (empty($data['username']) || trim($data['username']) == '') {
            $valid = false;
            $this->setError($this->lang->line('dashboard_empty_user_name'));
            return false;
        }

        if (empty($data['name']) || trim($data['name']) == '') {
            $valid = false;
            $this->setError($this->lang->line('dashboard_empty_widget_name'));
            return false;
        }

        if (empty($data['type']) || trim($data['type']) == '') {
            $valid = false;
            $this->setError($this->lang->line('dashboard_empty_widget_type'));
            return false;
        }

        if ($overwrite === false && !empty($dashboardWidgets)) {
            $item = $this->_nameAlreadyExist($data, $dashboardWidgets);

            if (!empty($item)) {
                $valid = false;
                $this->setError($this->lang->line('dashboard_widget_already_exist'), 422); //422 Unprocessable Entity
            }
        }

        if (
            $this->_nameAlreadyExist($data, $dashboardWidgets) === true &&
            ($is_admin === false && $this->_checkOwner($data) === false)
        ) {
            $this->clearErrors();
            $this->setError($this->lang->line('dashboard_widget_already_exist'), 422); //422 Unprocessable Entity
            $valid = false;
        }

        return $valid;
    }

    /**
     * Reorder user widgets
     *
     *
     * @param type $username - user which widgets were reordered
     * @param type $data  array of id and new position
     */
    public function reorderwidgets($username, $data)
    {
        if (empty($username)) {
            throw new Exception('Username not set');
        }

        if (empty($data)) {
            throw new Exception('Ordering is not specified');
        }

        try {
            $order_pairs_as_string = [];

            foreach ($data as $item => $value) {
                $order_pairs_as_string[] =
                    '(' . $this->db->escape_str($value['id']) . ',' . $this->db->escape_str($value['ordering']) . ')';
            }

            $sql = sprintf(
                "UPDATE dashboard_widgets
                                          SET ordering = c.ordering
                                          FROM (VALUES %s) AS c (id, ordering)
                                          WHERE c.id = dashboard_widgets.id and username='%s'",
                implode(',', $order_pairs_as_string),
                $this->db->escape_str($username),
            );

            $this->db->query($sql);
        } catch (Exception $e) {
            throw $e;
        }
        return true;
    }

    //************************************
    //
    // TODO: This functions should be revieed and replaced in all project if valuable
    // right now this is a copy/paste from save_search model
    //________________________________________________________

    public function setError($errorText, $errorCode = 406, $level = 'ERROR')
    {
        $i = count($this->errors);
        $this->errors[$i]['text'] = $errorText;
        $this->errors[$i]['errorCode'] = $errorCode;
    }

    public function getErrors($level = 'ERROR')
    {
        return $this->errors;
    }

    public function clearErrors()
    {
        $this->errors = [];
    }

    // END
    // ________________________________________________________

    public function delete_widgets($filter, $is_admin = false)
    {
        // delete widget alerts, handled by DB
        // delete widget
        try {
            $return = $this->db->where($filter)->delete($this->widgetsCollectionName);
            if ($this->db->affected_rows() < 0) {
                throw new Exception($this->lang->line('dashboard_widget_unable_to_delete'));
            }
        } catch (Exception $e) {
            throw $e;
        }
        return $return;
    }

    public function get_all_widgets($filter = [], $offset = '', $limit = '', $order = [])
    {
        try {
            $newFilter = [];
            $dashboards = [];
            // as we are joining the table the filter keys should be prefixed by the alias
            if (!empty($filter) && is_array($filter)) {
                if (array_key_exists('widgets', $filter)) {
                    $dashboards = $filter['widgets'];
                    unset($filter['widgets']);
                }

                foreach ($filter as $key => $val) {
                    $prefixedColName = 'w.' . $key;
                    $newFilter[$prefixedColName] = $val;
                }
            }

            // build a manual or_where out of the widget IDs from the current selected dashboard
            $or_where = [];
            if (!empty($dashboards)) {
                $or_where = '';
                $idx = 0;
                foreach ($dashboards as $dashboard) {
                    if ($idx > 0) {
                        $or_where .= 'OR ';
                    }
                    $or_where .= "w.id = '" . $this->db->escape_str($dashboard) . "' ";
                    $idx++;
                }
                $or_where = "($or_where)";
            }

            if (!empty($limit)) {
                $this->db->limit($limit, $offset);
            }
            if (!empty($order)) {
                reset($order);
                $field = key($order);
                $orderValue = current($order);
                $this->db->order_by($field, $orderValue);
            } else {
                $this->db->order_by('ordering', 'ASC');
                $this->db->order_by('id', 'ASC');
            }

            $query = $this->db
                ->select("w.*,array_to_string(array_agg(a.id),',') as alerts")
                ->from('dashboard_widgets AS w')
                ->join('dashboard_alerts AS a', 'a.widgetid = w.id', 'LEFT OUTER')
                ->where($newFilter)
                ->where($or_where, null, false)
                ->group_by('w.id')
                ->get();

            $result = [];
            foreach ((array) $query->result_array() as $DBResult) {
                $obj = new CF_Widget($DBResult);
                $result[] = $obj;
            }

            return $result;
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    public function get_all_widgets_with_alertIds($filter = [], $offset = '', $limit = '', $order = [])
    {
        if (!empty($limit)) {
            $this->db->limit($limit, $offset);
        }
        if (!empty($order)) {
            reset($order);
            $field = key($order);
            $orderValue = current($order);
            $this->db->order_by($field, $orderValue);
        }

        try {
            $query = $this->db
                ->select("w.*,array_to_string(array_agg(a.id),',') as alerts")
                ->from('dashboard_widgets AS w')
                ->join('dashboard_alerts AS a', 'a.widgetid = w.id', 'LEFT OUTER')
                ->where_in('a.id', $filter)
                ->group_by('w.id')
                ->get();

            $result = [];
            foreach ((array) $query->result_array() as $DBResult) {
                $obj = new CF_Widget($DBResult);
                $result[] = $obj;
            }
            return $result;
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    public function setDefaultFilter($filter)
    {
        $this->defaultFilter = $filter;
    }

    public function _nameAlreadyExist($data, $widgets)
    {
        $alreadyExist = false;
        $filter = $this->defaultFilter;
        $filter['name'] = $data['name'];
        $filter['widgets'] = $widgets;

        $result = $this->get_all_widgets($filter);

        if (!empty($result)) {
            $alreadyExist = true;
        }

        return $alreadyExist;
    }

    public function _checkOwner($data)
    {
        $isOwner = false;
        $filter = $this->defaultFilter;
        $filter['name'] = $data['name'];

        $currentItem = $this->get_all_widgets($filter);

        if (!empty($currentItem)) {
            $owner = $currentItem[0]->getUsername();

            if ($owner === $data['username']) {
                $isOwner = true;
            }
        }

        return $isOwner;
    }

    /**
     * @param $id
     * @param $data
     */
    public function updatePayload(int $id, array $data)
    {
        $this->db->query(
            'UPDATE "dashboard_widgets"
             SET payload = payload  || ?
             WHERE id = ?',
            [json_encode($data), $id],
        );
    }
}
