<?php

class CF_Dashboard
{
    public $id;
    public $username;
    public $name;
    public $public; // boolean
    public $widgets; // array
    public $sharedWith;

    public function __construct($params = [])
    {
        $this->id = isset($params['id']) ? $params['id'] : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->name = isset($params['name']) ? $params['name'] : null;
        $this->public = isset($params['public']) ? $params['public'] : null;
        $this->sharedWith = isset($params['sharedwith']) ? json_decode($params['sharedwith']) : null;

        $this->widgets = !empty($params['widgets']) ? explode(',', $params['widgets']) : [];
    }

    public function getId()
    {
        return $this->id;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getPublic()
    {
        return $this->public;
    }

    public function getWidgets()
    {
        return $this->widgets;
    }

    public function getSharedWith()
    {
        return $this->sharedWith;
    }

    public function setWidgets($widgets)
    {
        $this->widgets = $widgets;
    }
}
